/*
 * Decompiled with CFR 0.152.
 */
package cn.zh54.json.repair;

import cn.zh54.json.repair.JsonRepair;

public class TestCase {
    public static void doTest(String[] args) {
        TestCase.testCase("{'key': 'string', 'key2': false, \"key3\": null, \"key4\": unquoted}");
        TestCase.testCase("[1, 2, 3, 4");
        TestCase.testCase("\u6b22\u8fce\u8bbf\u95ee\u6211\u7684\u535a\u5ba254zh.cn,b\u7ad9\u8d26\u53f7:\u733f\u5927\u6656[]");
        TestCase.testCase("{");
        TestCase.testCase("[");
        TestCase.testCase("[]]");
        TestCase.testCase("\"");
        TestCase.testCase("\"\"\"");
        TestCase.testCase("{\"employees\":[\"John\", \"Anna\",");
        TestCase.testCase("{foo: [}");
        TestCase.testCase("{\"text\": \"The quick brown fox won\\'t jump\"}");
        TestCase.testCase("{\"value_1\": \"value_2\":data\"}");
        TestCase.testCase("{\"value_1\": true, COMMENT \"value_2\": \"data\"}");
        TestCase.testCase("- { \"test_key\": [\"test_value\", \"test_value2\"] }");
        TestCase.testCase("{ \"content\": \"[LINK](\"https://google.com\")\" }");
        TestCase.testCase("{ \"content\": \"[LINK](\", \"key\": true }");
        TestCase.testCase("{\"key\":\"\",}");
        TestCase.testCase("[{'transactionDate': '2025-05-31 10:36:55','fromAccount': null,'toAccount': null,'debit': null,'credit': 277300,'balance': 822300,'description': '2025 May 31 10:36:55 31 May 2025 Transfer from CREDPAY FINTECH LIMITED +2,773.00 8,223.00 E-Channel 100033250531103654318487604138','transactionType': 'OTHER'},{'transactionDate': '2025-06-01 18:54:45','fromAccount': null,'toAccount': null,'debit': 65000,'credit': null,'balance': 4850400,'description': '2025 Jun 01");
        TestCase.testCase("[{\"transactionDate\": \"2025-05-31 10:36:55\",\"fromAccount\": null,\"toAccount\": null,\"debit\": null,\"credit\": 277300,\"balance\": 822300,\"description\": \"2025 May 31 10:36:55 31 May 2025 Transfer from CREDPAY FINTECH LIMITED +2,773.00 8,223.00 E-Channel 100033250531103654318487604138\",\"transactionType\": \"OTHER\"},{\"transactionDate\": \"2025-06-01 18:54:45\",\"fromAccount\": null,\"toAccount\": null,\"debit\": 65000,\"credit\": null,\"balance\": 4850400,\"description\": \"2025 Jun 01");
    }

    private static void testCase(String badJson) {
        System.out.println("------");
        System.out.println("bad_json: " + badJson);
        System.out.println("good_json: " + JsonRepair.repairJson(badJson));
    }
}

