/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.mini.core.impl;

import com.nlf.mini.App;
import com.nlf.mini.core.AbstractScanner;
import com.nlf.mini.core.IScanner;
import com.nlf.mini.exception.NlfException;
import com.nlf.mini.plugin.IPlugin;
import com.nlf.mini.resource.ResourceFileFilter;
import com.nlf.mini.resource.i18n.I18nResource;
import com.nlf.mini.resource.i18n.comparator.I18nComparator;
import com.nlf.mini.util.FileUtil;
import com.nlf.mini.util.IOUtil;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class DefaultScanner
extends AbstractScanner {
    public static final String CHARSET = "utf-8";
    public static final String SUF_JAR = ".jar";
    public static final String SUF_PPT = ".properties";
    public static final String SUF_CLASS = ".class";
    private static final List<String> ignoreClasses = new ArrayList<String>(){
        {
            this.add(DefaultScanner.class.getName());
            this.add(IPlugin.class.getName());
            this.add(App.class.getName());
        }
    };
    private static final String PLUGIN_INTERFACE_NAME = IPlugin.class.getName().replace(".", "/");
    private static final String PLUGIN_APPLY_NAME = "onApply";
    protected ResourceFileFilter resourceFilter = new ResourceFileFilter();
    protected I18nComparator i18nComparator = new I18nComparator();
    protected Set<String> jars = new HashSet<String>();
    protected Set<String> classes = new HashSet<String>();

    protected Set<String> filterPath(String ... paths) {
        HashSet<String> l = new HashSet<String>();
        for (String p : paths) {
            File f;
            if (null == p || (p = p.trim()).length() < 1 || !(f = new File(p)).exists()) continue;
            if (f.isDirectory()) {
                String path = f.getAbsolutePath();
                if (path.endsWith(File.separator + ".")) {
                    path = path.substring(0, path.lastIndexOf(File.separator));
                }
                l.add(path);
                continue;
            }
            if (!f.getName().endsWith(SUF_JAR)) continue;
            l.add(f.getAbsolutePath());
        }
        return l;
    }

    protected Set<String> findFromClassPath() {
        return this.filterPath(System.getProperty("java.class.path").split(File.pathSeparator));
    }

    protected void findCallerPath() throws ClassNotFoundException, UnsupportedEncodingException {
        if (null == App.caller) {
            if (null == this.caller) {
                StackTraceElement t;
                String className;
                StackTraceElement[] sts = Thread.currentThread().getStackTrace();
                String callerClassName = null;
                Class<?> callerClass = null;
                for (int i = sts.length - 1; !(i <= -1 || (className = (t = sts[i]).getClassName()).startsWith(App.PACKAGE) && null != (callerClass = Class.forName(callerClassName)).getClassLoader()); --i) {
                    callerClassName = className;
                }
                if (null != callerClass) {
                    String callerPath = callerClass.getProtectionDomain().getCodeSource().getLocation().getPath();
                    App.caller = new File(URLDecoder.decode(callerPath, CHARSET)).getAbsolutePath();
                }
            } else {
                App.caller = this.caller;
            }
        }
    }

    protected void findFramePath() throws UnsupportedEncodingException {
        if (null == App.frame) {
            App.frame = new File(URLDecoder.decode(IScanner.class.getProtectionDomain().getCodeSource().getLocation().getPath(), CHARSET)).getAbsolutePath();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<String> findFromCallerClassPath() throws IOException {
        HashSet<String> classPaths = new HashSet<String>();
        String callerPath = App.caller;
        if (callerPath.endsWith(SUF_JAR)) {
            JarFile jar;
            block3: {
                jar = null;
                try {
                    Attributes attrs;
                    String classPath;
                    jar = new JarFile(callerPath);
                    Manifest mf = jar.getManifest();
                    if (null == mf || null == (classPath = (attrs = mf.getMainAttributes()).getValue("Class-Path"))) break block3;
                    String[] cps = classPath.split(" ");
                    classPaths.addAll(this.filterPath(cps));
                }
                catch (Throwable throwable) {
                    IOUtil.closeQuietly(jar);
                    throw throwable;
                }
            }
            IOUtil.closeQuietly(jar);
        }
        return classPaths;
    }

    @Override
    public IScanner start() {
        try {
            this.findCallerPath();
            this.findAppRoot();
            this.findFramePath();
            System.out.println("App.caller         = " + App.caller);
            System.out.println("App.root           = " + App.root);
            System.out.println("App.frame          = " + App.frame);
            HashSet<String> paths = new HashSet<String>();
            paths.add(App.caller);
            paths.add(App.root);
            paths.add(App.frame);
            paths.addAll(this.findFromClassPath());
            paths.addAll(this.findFromCallerClassPath());
            for (String p : paths) {
                if (p.endsWith(SUF_JAR)) {
                    this.jars.add(p);
                    continue;
                }
                this.classes.add(p);
            }
            this.scan();
            this.buildI18n();
        }
        catch (Exception e) {
            throw new NlfException(e);
        }
        return this;
    }

    protected void buildI18n() {
        if (App.I18N.size() > 1) {
            ArrayList<String> l = new ArrayList<String>(App.I18N);
            l.sort(this.i18nComparator);
            App.I18N.clear();
            App.I18N.addAll(l);
        }
    }

    protected void scanClasses(File file, String root) {
        if (file.isDirectory()) {
            File[] fs = file.listFiles(this.resourceFilter);
            if (null != fs) {
                for (File f : fs) {
                    this.scanClasses(f, root);
                }
            }
            return;
        }
        String fileName = file.getAbsolutePath().replace(root, "");
        if (fileName.startsWith(File.separator)) {
            fileName = fileName.substring(File.separator.length());
        }
        if (fileName.endsWith(SUF_PPT)) {
            String name = fileName.substring(0, fileName.lastIndexOf(".")).replace(File.separator, ".");
            for (Locale locale : Locale.getAvailableLocales()) {
                String tag = "_" + locale.getLanguage();
                if (!name.endsWith(tag)) continue;
                name = name.substring(0, name.lastIndexOf(tag));
                break;
            }
            I18nResource ir = new I18nResource();
            ir.setRoot(root);
            ir.setInJar(false);
            ir.setName(name);
            ir.setFileName(fileName);
            App.I18N_RESOURCE.add(ir);
            App.I18N.add(name);
        } else if (fileName.endsWith(SUF_CLASS) && !fileName.contains("$")) {
            String name;
            String s = null;
            try {
                s = FileUtil.readAsText(file);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (null != s && s.contains(PLUGIN_INTERFACE_NAME) && s.contains(PLUGIN_APPLY_NAME) && !ignoreClasses.contains(name = fileName.substring(0, fileName.lastIndexOf(".")).replace(File.separator, "."))) {
                App.plugins.add(name);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scanJar(File jarFile) throws IOException {
        String root = jarFile.getAbsolutePath();
        System.out.println("[v] " + root);
        ZipFile zip = null;
        try {
            zip = new ZipFile(jarFile);
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                String name;
                ZipEntry entry = entries.nextElement();
                String fileName = entry.getName();
                if (fileName.endsWith(SUF_PPT)) {
                    String name2 = fileName.substring(0, fileName.lastIndexOf(".")).replace("/", ".");
                    for (Locale locale : Locale.getAvailableLocales()) {
                        String tag = "_" + locale;
                        if (!name2.endsWith(tag)) continue;
                        name2 = name2.substring(0, name2.lastIndexOf(tag));
                        break;
                    }
                    I18nResource ir = new I18nResource();
                    ir.setRoot(root);
                    ir.setInJar(true);
                    ir.setName(name2);
                    ir.setFileName(fileName);
                    App.I18N_RESOURCE.add(ir);
                    App.I18N.add(name2);
                    continue;
                }
                if (!fileName.endsWith(SUF_CLASS) || fileName.contains("$")) continue;
                String s = null;
                try {
                    s = FileUtil.readAsText(zip.getInputStream(entry), CHARSET);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                if (null == s || !s.contains(PLUGIN_INTERFACE_NAME) || !s.contains(PLUGIN_APPLY_NAME) || ignoreClasses.contains(name = fileName.substring(0, fileName.lastIndexOf(".")).replace(File.separator, "."))) continue;
                App.plugins.add(name);
            }
        }
        catch (Throwable throwable) {
            IOUtil.closeQuietly(zip);
            throw throwable;
        }
        IOUtil.closeQuietly(zip);
    }

    protected void scan() throws IOException {
        App.I18N_RESOURCE.clear();
        for (String p : this.classes) {
            System.out.println("[v] " + p);
            App.DIRECTORIES.add(p);
            this.scanClasses(new File(p), p);
        }
        for (String p : this.jars) {
            this.scanJar(new File(p));
        }
    }

    protected void findAppRoot() {
        if (null == App.root) {
            String callerPath = App.caller;
            App.root = callerPath.endsWith(SUF_JAR) ? new File(callerPath).getParentFile().getAbsolutePath() : callerPath;
        }
    }
}

