/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.mini.dao;

import com.nlf.mini.App;
import com.nlf.mini.dao.DaoType;
import com.nlf.mini.dao.IDao;
import com.nlf.mini.dao.connection.ConnectionFactory;
import com.nlf.mini.dao.connection.IConnection;
import com.nlf.mini.dao.exception.DaoException;
import com.nlf.mini.dao.executer.AbstractDaoExecuter;
import com.nlf.mini.dao.executer.IDaoExecuter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractDao
implements IDao {
    protected static final Map<String, Map<String, String>> EXECUTERS = new HashMap<String, Map<String, String>>();
    protected String alias;
    protected IConnection connection;

    @Override
    public String getAlias() {
        return this.alias;
    }

    public void init(String alias) {
        this.alias = alias;
        this.connection = ConnectionFactory.getConnection(alias);
    }

    @Override
    public DaoType getType() {
        return DaoType.sql;
    }

    protected IConnection getConnection() {
        return this.connection;
    }

    protected IDaoExecuter getImpl(String dbType, String executerInterface) {
        Map impls = EXECUTERS.computeIfAbsent(dbType, k -> new HashMap(2));
        if (!impls.containsKey(executerInterface)) {
            List<String> l = App.getImplements(executerInterface);
            for (String klass : l) {
                IDaoExecuter executer = (IDaoExecuter)App.getProxy().newInstance(klass);
                if (!executer.support(dbType)) continue;
                impls.put(executerInterface, klass);
                return executer;
            }
            impls.put(executerInterface, null);
        } else {
            String impl = (String)impls.get(executerInterface);
            if (null != impl) {
                return (IDaoExecuter)App.getProxy().newInstance(impl);
            }
        }
        throw new DaoException(App.getProperty("nlf.exception.dao.executer.not_found", dbType, executerInterface));
    }

    protected IDaoExecuter getExecuter(String executerInterface) {
        IConnection connection = this.getConnection();
        String dbType = connection.getDbSetting().getDbType();
        AbstractDaoExecuter executer = (AbstractDaoExecuter)this.getImpl(dbType, executerInterface);
        executer.setConnection(connection);
        return executer;
    }

    @Override
    public void close() {
        this.getConnection().close();
    }
}

