/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.mini.dao.paging;

import com.nlf.mini.App;
import com.nlf.mini.dao.paging.IPageable;
import com.nlf.mini.dao.paging.IPagingRender;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public abstract class AbstractPageable<M>
implements IPageable<M> {
    protected int pageSize;
    protected int recordCount;
    protected int pageNumber;
    protected List<M> data = new ArrayList<M>();

    @Override
    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = Math.max(pageSize, 1);
    }

    @Override
    public int getRecordCount() {
        return this.recordCount;
    }

    public void setRecordCount(int recordCount) {
        this.recordCount = Math.max(recordCount, 0);
    }

    @Override
    public int getPageCount() {
        return this.recordCount < 1 || this.pageSize < 1 ? 1 : (int)Math.ceil((double)this.recordCount * 1.0 / (double)this.pageSize);
    }

    @Override
    public int getPreviousPageNumber() {
        int prevNumber = this.pageNumber - 1;
        return Math.max(prevNumber, 1);
    }

    @Override
    public int getNextPageNumber() {
        int nextNumber = this.pageNumber + 1;
        int pageCount = this.getPageCount();
        return Math.min(nextNumber, pageCount);
    }

    @Override
    public boolean isHasNextPage() {
        return this.getPageNumber() < this.getLastPageNumber();
    }

    @Override
    public int getFirstPageNumber() {
        return 1;
    }

    @Override
    public int getLastPageNumber() {
        return this.getPageCount();
    }

    @Override
    public int getSize() {
        return null == this.data ? 0 : this.data.size();
    }

    @Override
    public int getPageNumber() {
        return this.pageNumber;
    }

    public void setPageNumber(int pageNumber) {
        this.pageNumber = Math.max(pageNumber, 1);
    }

    public AbstractPageable() {
        this.setPageNumber(1);
        this.setPageSize(1);
    }

    public AbstractPageable(List<M> data, int pageSize, int pageNumber, int recordCount) {
        this.setData(data);
        this.setPageSize(pageSize);
        this.setPageNumber(pageNumber);
        this.setRecordCount(recordCount);
    }

    protected int[] genNearPageNumbers(int count) {
        int pageCount = this.getPageCount();
        int start = this.pageNumber - count;
        int end = this.pageNumber + count;
        end = (end = Math.max(end, 1)) > pageCount ? this.pageNumber : end;
        start = Math.max(start, 1);
        int[] m = new int[end + 1 - start];
        for (int i = 0; i < m.length; ++i) {
            m[i] = start + i;
        }
        return m;
    }

    @Override
    public int[] getNearPageNumbers() {
        return this.genNearPageNumbers(App.getPropertyInt("nlf.paging.near", 2));
    }

    @Override
    public List<M> getData() {
        return this.data;
    }

    public void setData(List<M> data) {
        this.data = data;
    }

    @Override
    public M get(int index) {
        return this.data.get(index);
    }

    @Override
    public boolean add(M o) {
        return this.data.add(o);
    }

    @Override
    public void add(int index, M element) {
        this.data.add(index, element);
    }

    @Override
    public boolean addAll(Collection<? extends M> c) {
        return this.data.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends M> c) {
        return this.data.addAll(index, c);
    }

    @Override
    public void clear() {
        this.data.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.data.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.data.containsAll(c);
    }

    @Override
    public int indexOf(Object o) {
        return this.data.indexOf(o);
    }

    @Override
    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    @Override
    public Iterator<M> iterator() {
        return this.data.iterator();
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.data.lastIndexOf(o);
    }

    @Override
    public ListIterator<M> listIterator() {
        return this.data.listIterator();
    }

    @Override
    public ListIterator<M> listIterator(int index) {
        return this.data.listIterator(index);
    }

    @Override
    public boolean remove(Object o) {
        return this.data.remove(o);
    }

    @Override
    public M remove(int index) {
        return this.data.remove(index);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.data.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.data.retainAll(c);
    }

    @Override
    public M set(int index, M element) {
        return this.data.set(index, element);
    }

    @Override
    public int size() {
        return this.data.size();
    }

    @Override
    public List<M> subList(int fromIndex, int toIndex) {
        return this.data.subList(fromIndex, toIndex);
    }

    @Override
    public Object[] toArray() {
        return this.data.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.data.toArray(a);
    }

    public String toString() {
        List<String> impls = App.getImplements(IPagingRender.class);
        for (String impl : impls) {
            IPagingRender render = (IPagingRender)App.getProxy().newInstance(impl);
            if (!render.support()) continue;
            return render.render(this);
        }
        return "";
    }
}

