/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.mini.dao.setting;

import com.nlf.mini.App;
import com.nlf.mini.dao.DaoType;
import com.nlf.mini.dao.exception.DaoException;
import com.nlf.mini.dao.setting.IDbSetting;
import com.nlf.mini.dao.setting.IDbSettingManager;
import com.nlf.mini.dao.setting.impl.DefaultDbSettingComparator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbSettingFactory {
    private static final Logger logger = LoggerFactory.getLogger(DbSettingFactory.class);
    public static final Comparator<IDbSetting> DEFAULT_COMPARATOR = new DefaultDbSettingComparator();
    protected static final Map<String, IDbSetting> SETTING_POOL = new HashMap<String, IDbSetting>();
    protected static final List<IDbSetting> SETTING_LIST = new ArrayList<IDbSetting>();
    protected static Comparator<IDbSetting> comparator = DEFAULT_COMPARATOR;
    protected static IDbSettingManager dbSettingManager;

    protected DbSettingFactory() {
    }

    private static synchronized void init() {
        dbSettingManager = (IDbSettingManager)App.getProxy().newInstance(IDbSettingManager.class.getName());
        List<IDbSetting> l = dbSettingManager.listDbSettings();
        for (IDbSetting o : l) {
            SETTING_POOL.put(o.getAlias(), o);
            SETTING_LIST.add(o);
        }
        if (l.size() > 0) {
            logger.debug(App.getProperty("nlf.dao.setting.found", l.size(), l));
            DbSettingFactory.sort();
        }
    }

    protected static synchronized void sort() {
        SETTING_LIST.sort(comparator);
    }

    public static synchronized void setComparator(Comparator<IDbSetting> c) {
        comparator = c;
    }

    public static List<String> getSettingAliasList() {
        ArrayList<String> l = new ArrayList<String>();
        for (IDbSetting setting : SETTING_LIST) {
            l.add(setting.getAlias());
        }
        return l;
    }

    public static synchronized void addSetting(IDbSetting setting) {
        String alias = setting.getAlias();
        DbSettingFactory.removeSetting(alias);
        SETTING_LIST.add(setting);
        SETTING_POOL.put(alias, setting);
        DbSettingFactory.sort();
    }

    public static synchronized void removeSetting(String alias) {
        if (!SETTING_POOL.containsKey(alias)) {
            return;
        }
        int index = -1;
        int j = SETTING_LIST.size();
        for (int i = 0; i < j; ++i) {
            if (!SETTING_LIST.get(i).getAlias().equals(alias)) continue;
            index = i;
            break;
        }
        if (index > -1) {
            SETTING_LIST.remove(index);
        }
        SETTING_POOL.remove(alias);
    }

    public static IDbSetting getSetting(String alias) {
        if (SETTING_POOL.containsKey(alias)) {
            return SETTING_POOL.get(alias);
        }
        throw new DaoException(App.getProperty("nlf.exception.dao.setting.not_found", alias));
    }

    public static int size() {
        return SETTING_POOL.size();
    }

    public static IDbSetting getDefaultSetting() {
        if (SETTING_LIST.size() < 1) {
            throw new DaoException(App.getProperty("nlf.exception.dao.setting.default_not_found", new Object[0]));
        }
        return SETTING_LIST.get(0);
    }

    public static IDbSetting getDefaultSetting(DaoType daoType) {
        for (IDbSetting setting : SETTING_LIST) {
            if (!setting.getDaoType().equals((Object)daoType)) continue;
            return setting;
        }
        throw new DaoException(App.getProperty("nlf.exception.dao.setting.default_not_found", new Object[0]));
    }

    static {
        DbSettingFactory.init();
    }
}

