/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.mini.extend.dao.sql.dbType.common;

import com.nlf.mini.App;
import com.nlf.mini.Bean;
import com.nlf.mini.dao.exception.DaoException;
import com.nlf.mini.dao.paging.PageData;
import com.nlf.mini.extend.dao.sql.AbstractSqlExecuter;
import com.nlf.mini.extend.dao.sql.ISqlTemplate;
import com.nlf.mini.extend.dao.sql.SqlConnection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ASqlTemplate
extends AbstractSqlExecuter
implements ISqlTemplate {
    private static final Logger logger = LoggerFactory.getLogger(ASqlTemplate.class);
    protected List<String> sqls = new ArrayList<String>();
    protected Bean param = new Bean();

    @Override
    public ISqlTemplate sql(String sql) {
        this.sqls.add(sql);
        return this;
    }

    @Override
    public ISqlTemplate sqlIf(String sql, boolean condition) {
        if (condition) {
            this.sql(sql);
        }
        return this;
    }

    @Override
    public ISqlTemplate param(Bean param) {
        for (Map.Entry<String, Object> en : param.entrySet()) {
            this.param(en.getKey(), en.getValue());
        }
        return this;
    }

    @Override
    public ISqlTemplate param(String key, Object value) {
        this.param.set(key, value);
        return this;
    }

    @Override
    protected String buildSql() {
        StringBuilder s = new StringBuilder();
        for (String sql : this.sqls) {
            s.append(sql);
        }
        return s.toString();
    }

    protected List<Bean> query(String sql) {
        this.params.clear();
        this.sql = sql = this.buildParams(sql, this.param);
        logger.debug(this.buildLog());
        return this.queryList();
    }

    @Override
    public List<Bean> query() {
        return this.query(this.buildSql());
    }

    @Override
    public List<Bean> top(int count) {
        throw new DaoException(App.getProperty("nlf.exception.dao.operation_not_support", new Object[0]));
    }

    @Override
    public Bean topOne() {
        List<Bean> l = this.top(1);
        if (l.size() < 1) {
            throw new DaoException(App.getProperty("nlf.exception.dao.select.one.not_found", new Object[0]));
        }
        return l.get(0);
    }

    @Override
    public Bean one() {
        List<Bean> l = this.query();
        if (l.size() < 1) {
            throw new DaoException(App.getProperty("nlf.exception.dao.select.one.not_found", new Object[0]));
        }
        return l.get(0);
    }

    @Override
    public int count() {
        List<Bean> l = this.query("SELECT COUNT(*) NLFCOUNT_ FROM (" + this.buildSql() + ") NLFTABLE_");
        if (l.size() < 1) {
            throw new DaoException(App.getProperty("nlf.exception.dao.select.one.not_found", new Object[0]));
        }
        Bean o = l.get(0);
        return o.getInt("NLFCOUNT_", 0);
    }

    @Override
    public PageData page(int pageNumber, int pageSize) {
        throw new DaoException(App.getProperty("nlf.exception.dao.operation_not_support", new Object[0]));
    }

    @Override
    public int update() {
        int n;
        PreparedStatement stmt;
        block5: {
            this.params.clear();
            this.sql = this.buildParams(this.buildSql(), this.param);
            logger.debug(this.buildLog());
            stmt = null;
            SqlConnection conn = (SqlConnection)this.connection;
            stmt = conn.getConnection().prepareStatement(this.sql);
            conn.setStatement(stmt);
            this.bindParams(stmt);
            if (!conn.isInBatch()) break block5;
            stmt.addBatch();
            int n2 = -1;
            this.finalize(stmt);
            return n2;
        }
        try {
            n = stmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new DaoException(e);
            }
            catch (Throwable throwable) {
                this.finalize(stmt);
                throw throwable;
            }
        }
        this.finalize(stmt);
        return n;
    }

    @Override
    public Iterator<Bean> iterator() {
        this.params.clear();
        this.sql = this.buildParams(this.buildSql(), this.param);
        logger.debug(this.buildLog());
        return this.queryIterator();
    }
}

