/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.mini.serialize;

import com.nlf.mini.App;
import com.nlf.mini.exception.NlfException;
import com.nlf.mini.serialize.IParser;
import com.nlf.mini.serialize.IWrapper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ConvertFactory {
    public static final Map<String, String> PARSERS = new HashMap<String, String>();
    public static final Map<String, String> WRAPPERS = new HashMap<String, String>();

    protected ConvertFactory() {
    }

    public static IParser getParser(String format) {
        if (!PARSERS.containsKey(format)) {
            List<String> impls = App.getImplements(IParser.class);
            for (String klass : impls) {
                IParser parser = (IParser)App.getProxy().newInstance(klass);
                if (!parser.support(format)) continue;
                PARSERS.put(format, klass);
                return parser;
            }
            PARSERS.put(format, null);
        } else {
            String impl = PARSERS.get(format);
            if (null != impl) {
                return (IParser)App.getProxy().newInstance(impl);
            }
        }
        throw new NlfException(App.getProperty("nlf.serialize.parser.not_found", format));
    }

    public static IWrapper getWrapper(String format) {
        if (!WRAPPERS.containsKey(format)) {
            List<String> impls = App.getImplements(IWrapper.class);
            for (String klass : impls) {
                IWrapper wrapper = (IWrapper)App.getProxy().newInstance(klass);
                if (!wrapper.support(format)) continue;
                WRAPPERS.put(format, klass);
                return wrapper;
            }
            WRAPPERS.put(format, null);
        } else {
            String impl = WRAPPERS.get(format);
            if (null != impl) {
                return (IWrapper)App.getProxy().newInstance(impl);
            }
        }
        throw new NlfException(App.getProperty("nlf.serialize.wrapper.not_found", format));
    }
}

