/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.mini.serialize.json.impl;

import com.nlf.mini.dao.paging.IPageable;
import com.nlf.mini.serialize.AbstractWrapper;
import com.nlf.mini.util.Base64Util;
import com.nlf.mini.util.DateUtil;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;

public class DefaultJsonWrapper
extends AbstractWrapper {
    protected String quote = "\"";

    protected String wrapNumber(Object o) {
        return o + "";
    }

    protected String wrapBool(Object o) {
        return o + "";
    }

    protected String wrapString(Object o) {
        String s = o + "";
        s = s.replace("\\", "\\\\");
        s = s.replace("\b", "\\b");
        s = s.replace("\t", "\\t");
        s = s.replace("\n", "\\n");
        s = s.replace("\f", "\\f");
        s = s.replace("\r", "\\r");
        s = s.replace("\"", "\\\"");
        return this.quote + s + this.quote;
    }

    protected String wrapDate(Object o) {
        return this.wrapString(DateUtil.ymdhms((Date)o));
    }

    protected String wrapByteArray(Object o) {
        byte[] d = (byte[])o;
        return this.wrapString(Base64Util.encode(d));
    }

    protected String buildString(StringBuilder s, String prefix, String suffix) {
        if (s.length() > 0) {
            s.deleteCharAt(0);
        }
        s.insert(0, "[");
        s.append("]");
        return s.toString();
    }

    protected String wrapShortArray(Object o) {
        short[] l = (short[])o;
        StringBuilder s = new StringBuilder();
        for (short n : l) {
            s.append(",");
            s.append(n);
        }
        return this.buildString(s, "[", "]");
    }

    protected String wrapIntArray(Object o) {
        int[] l = (int[])o;
        StringBuilder s = new StringBuilder();
        for (int n : l) {
            s.append(",");
            s.append(n);
        }
        return this.buildString(s, "[", "]");
    }

    protected String wrapLongArray(Object o) {
        long[] l = (long[])o;
        StringBuilder s = new StringBuilder();
        for (long n : l) {
            s.append(",");
            s.append(n);
        }
        return this.buildString(s, "[", "]");
    }

    protected String wrapFloatArray(Object o) {
        float[] l = (float[])o;
        StringBuilder s = new StringBuilder();
        for (float n : l) {
            s.append(",");
            s.append(n);
        }
        return this.buildString(s, "[", "]");
    }

    protected String wrapDoubleArray(Object o) {
        double[] l = (double[])o;
        StringBuilder s = new StringBuilder();
        for (double n : l) {
            s.append(",");
            s.append(n);
        }
        return this.buildString(s, "[", "]");
    }

    protected String wrapArray(Object o) {
        if (o instanceof byte[]) {
            return this.wrapByteArray(o);
        }
        if (o instanceof short[]) {
            return this.wrapShortArray(o);
        }
        if (o instanceof int[]) {
            return this.wrapIntArray(o);
        }
        if (o instanceof long[]) {
            return this.wrapLongArray(o);
        }
        if (o instanceof float[]) {
            return this.wrapFloatArray(o);
        }
        if (o instanceof double[]) {
            return this.wrapDoubleArray(o);
        }
        Object[] l = (Object[])o;
        return this.wrapCollection(Arrays.asList(l));
    }

    protected String wrapCollection(Object o) {
        Collection l = (Collection)o;
        StringBuilder s = new StringBuilder();
        for (Object obj : l) {
            s.append(",");
            s.append(this.wrap(obj));
        }
        return this.buildString(s, "[", "]");
    }

    protected String wrapEnumeration(Object o) {
        Enumeration l = (Enumeration)o;
        StringBuilder s = new StringBuilder();
        while (l.hasMoreElements()) {
            s.append(",");
            s.append(this.wrap(l.nextElement()));
        }
        return this.buildString(s, "[", "]");
    }

    protected String wrapMap(Object o) {
        Map m = (Map)o;
        StringBuilder s = new StringBuilder();
        s.append("{");
        Iterator it = m.keySet().iterator();
        while (it.hasNext()) {
            Object key = it.next();
            s.append(this.wrapString(key + ""));
            s.append(":");
            s.append(this.wrap(m.get(key)));
            if (!it.hasNext()) continue;
            s.append(",");
        }
        s.append("}");
        return s.toString();
    }

    protected String wrapObject(Object o) {
        try {
            StringBuilder s = new StringBuilder();
            s.append("{");
            BeanInfo info = Introspector.getBeanInfo(o.getClass(), Object.class);
            PropertyDescriptor[] props = info.getPropertyDescriptors();
            int j = props.length;
            for (int i = 0; i < j; ++i) {
                if (i > 0) {
                    s.append(",");
                }
                PropertyDescriptor desc = props[i];
                s.append(this.wrapString(desc.getName()));
                s.append(":");
                Method method = desc.getReadMethod();
                if (null == method) {
                    s.append(this.wrap(null));
                    continue;
                }
                s.append(this.wrap(method.invoke(o, new Object[0])));
            }
            s.append("}");
            return s.toString();
        }
        catch (IntrospectionException | IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String wrap(Object o) {
        StringBuilder s = new StringBuilder();
        if (null == o) {
            s.append("null");
        } else if (o instanceof Number) {
            s.append(this.wrapNumber(o));
        } else if (o instanceof Boolean) {
            s.append(this.wrapBool(o));
        } else if (o instanceof Character || o instanceof String) {
            s.append(this.wrapString(o));
        } else if (o instanceof Date) {
            s.append(this.wrapDate(o));
        } else if (o.getClass().isArray()) {
            s.append(this.wrapArray(o));
        } else if (o instanceof IPageable) {
            s.append(this.wrapObject(o));
        } else if (o instanceof Collection) {
            s.append(this.wrapCollection(o));
        } else if (o instanceof Map) {
            s.append(this.wrapMap(o));
        } else if (o instanceof Enumeration) {
            s.append(this.wrapEnumeration(o));
        } else if (o instanceof Enum) {
            s.append(this.wrapString(o));
        } else {
            s.append(this.wrapObject(o));
        }
        return s.toString();
    }

    @Override
    public boolean support(String format) {
        return "json".equalsIgnoreCase(format);
    }
}

