/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.mini.util;

import com.nlf.mini.util.IOUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class MathUtil {
    private static final int BYTE_LENGTH = 8;

    private MathUtil() {
    }

    public static byte[] toBit(byte value) {
        byte[] b = new byte[8];
        for (int i = 0; i < 8; ++i) {
            b[i] = (byte)(value >> 8 - i - 1 & 1);
        }
        return b;
    }

    public static byte[] toBit(byte[] value) {
        int size = value.length;
        byte[] b = new byte[8 * size];
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < 8; ++j) {
                b[i * 8 + j] = (byte)(value[i] >> 8 - j - 1 & 1);
            }
        }
        return b;
    }

    public static byte toByte(byte[] bits) {
        int len = bits.length;
        if (len > 8) {
            throw new IllegalArgumentException();
        }
        byte[] padded = bits;
        if (len < 8) {
            padded = new byte[8];
            System.arraycopy(bits, 0, padded, 8 - len, len);
        }
        StringBuilder s = new StringBuilder();
        for (byte bit : padded) {
            s.append(bit);
        }
        int b = Integer.parseInt(s.toString(), 2);
        if (bits[0] == 1) {
            b -= 256;
        }
        return (byte)b;
    }

    public static byte[] toBytes(byte[] bits) {
        int len = bits.length;
        int size = (int)Math.ceil((double)len * 1.0 / 8.0);
        int total = size * 8;
        byte[] bytes = new byte[size];
        byte[] padded = bits;
        if (total != len) {
            padded = new byte[total];
            System.arraycopy(bits, 0, padded, total - len, len);
        }
        for (int i = 0; i < size; ++i) {
            byte[] b = new byte[8];
            System.arraycopy(padded, i * 8, b, 0, 8);
            bytes[i] = MathUtil.toByte(b);
        }
        return bytes;
    }

    public static byte[] toByte(int value, int size) {
        byte[] b = new byte[size];
        for (int i = 0; i < size; ++i) {
            b[i] = (byte)(value >>> (size - i - 1) * 8 & 0xFF);
        }
        return b;
    }

    public static byte[] toByte(long value, int size) {
        byte[] b = new byte[size];
        for (int i = 0; i < size; ++i) {
            b[i] = (byte)(value >>> (size - i - 1) * 8 & 0xFFL);
        }
        return b;
    }

    public static int toInt(byte[] b) {
        int n = 0;
        int j = b.length;
        for (int i = 0; i < j; ++i) {
            n += (b[i] & 0xFF) << (j - i - 1) * 8;
        }
        return n;
    }

    public static long toLong(byte[] b) {
        long n = 0L;
        int j = b.length;
        for (int i = 0; i < j; ++i) {
            n += (long)(b[i] & 0xFF) << (j - i - 1) * 8;
        }
        return n;
    }

    public static byte[] merge(byte[] a, byte[] b) {
        int la = a.length;
        int lb = b.length;
        byte[] t = new byte[la + lb];
        System.arraycopy(a, 0, t, 0, la);
        System.arraycopy(b, 0, t, la, lb);
        return t;
    }

    public static byte[] merge(byte[] ... arrays) {
        byte[] t = null;
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            for (byte[] b : arrays) {
                os.write(b);
            }
            os.flush();
            t = os.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            IOUtil.closeQuietly(os);
        }
        return t;
    }

    public static byte[] sub(byte[] src, int from, int to) {
        byte[] t = new byte[to - from + 1];
        System.arraycopy(src, from, t, 0, to - from + 1);
        return t;
    }
}

