/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.mini.core;

import com.nlf.mini.Bean;
import java.beans.IntrospectionException;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;

public abstract class AbstractBean
implements Serializable {
    private static final String TYPE_CLASS_PREFIX = "class [";

    protected Object convertString(String object, String type) {
        Object value = object;
        if ("byte".equals(type)) {
            value = Byte.parseByte(object);
        } else if ("short".equals(type)) {
            value = Short.parseShort(object);
        } else if ("int".equals(type)) {
            value = Integer.parseInt(object);
        } else if ("long".equals(type)) {
            value = Long.parseLong(object);
        } else if ("float".equals(type)) {
            value = Float.valueOf(Float.parseFloat(object));
        } else if ("double".equals(type)) {
            value = Double.parseDouble(object);
        }
        return value;
    }

    protected Object convertInteger(int object, String type) {
        Number value = object;
        if ("byte".equals(type)) {
            value = (byte)object;
        } else if ("short".equals(type)) {
            value = (short)object;
        }
        return value;
    }

    protected Object convertLong(long object, String type) {
        Number value = object;
        if ("byte".equals(type)) {
            value = (byte)object;
        } else if ("short".equals(type)) {
            value = (short)object;
        } else if ("int".equals(type)) {
            value = (int)object;
        }
        return value;
    }

    protected Object convertDouble(double object, String type) {
        Number value = object;
        if ("byte".equals(type)) {
            value = (byte)object;
        } else if ("short".equals(type)) {
            value = (short)object;
        } else if ("int".equals(type)) {
            value = (int)object;
        } else if ("long".equals(type)) {
            value = (long)object;
        } else if ("float".equals(type)) {
            value = Float.valueOf((float)object);
        }
        return value;
    }

    protected Object convertBigDecimal(BigDecimal object, String type) {
        Number value = object;
        if ("byte".equals(type)) {
            value = object.byteValue();
        } else if ("short".equals(type)) {
            value = object.shortValue();
        } else if ("int".equals(type)) {
            value = object.intValue();
        } else if ("long".equals(type)) {
            value = object.longValue();
        } else if ("float".equals(type)) {
            value = Float.valueOf(object.floatValue());
        } else if ("double".equals(type)) {
            value = object.doubleValue();
        }
        return value;
    }

    protected Object convert(Object object, Class<?> propType, Type paramType) throws IntrospectionException, InvocationTargetException, IllegalAccessException {
        Object value = object;
        String paramTypeString = paramType + "";
        if (null != object) {
            if (value instanceof Integer) {
                value = this.convertInteger((Integer)value, paramTypeString);
            } else if (value instanceof Long) {
                value = this.convertLong((Long)value, paramTypeString);
            } else if (value instanceof BigDecimal) {
                value = this.convertBigDecimal((BigDecimal)value, paramTypeString);
            } else if (value instanceof Double) {
                value = this.convertDouble((Double)value, paramTypeString);
            } else if (value instanceof String) {
                value = this.convertString((String)value, paramTypeString);
            } else if (value instanceof Bean) {
                value = ((Bean)value).toObject(propType);
            } else if (value instanceof List) {
                Type elType = propType.getComponentType();
                if (null == elType) {
                    elType = ((ParameterizedType)paramType).getActualTypeArguments()[0];
                }
                List l = (List)value;
                int size = l.size();
                HashMap cache = new HashMap(size);
                int j = l.size();
                for (int i = 0; i < j; ++i) {
                    Object el = l.get(i);
                    if (!(el instanceof Bean)) continue;
                    cache.put(i, ((Bean)el).toObject(elType));
                }
                for (Map.Entry entry : cache.entrySet()) {
                    l.set((Integer)entry.getKey(), entry.getValue());
                }
                if (paramTypeString.startsWith(Set.class.getName())) {
                    value = new HashSet(l);
                } else if (paramTypeString.startsWith(Queue.class.getName())) {
                    value = new LinkedList(l);
                } else if (paramTypeString.startsWith(TYPE_CLASS_PREFIX)) {
                    value = Array.newInstance(elType, size);
                    for (int i = 0; i < size; ++i) {
                        Array.set(value, i, l.get(i));
                    }
                }
            }
        }
        return value;
    }
}

