/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.mini.dao.setting.impl;

import com.nlf.mini.App;
import com.nlf.mini.Bean;
import com.nlf.mini.dao.exception.DaoException;
import com.nlf.mini.dao.setting.IDbSetting;
import com.nlf.mini.dao.setting.IDbSettingManager;
import com.nlf.mini.dao.setting.IDbSettingProvider;
import com.nlf.mini.util.StringUtil;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesDbSettingManager
implements IDbSettingManager {
    private static final Logger logger = LoggerFactory.getLogger(PropertiesDbSettingManager.class);
    public static final String KEY_TYPE = "type";
    public static final String KEY_ALIAS = "alias";
    public static final String DEFAULT_SETTING_PREFIX = "db.alias";
    public static final String SETTING_PREFIX = App.getPropertyString("nlf.dao.setting.prefix", "db.alias");
    protected static final List<IDbSettingProvider> DB_SETTING_PROVIDERS = new ArrayList<IDbSettingProvider>();

    protected static void init() {
        List<String> impls = App.getImplements(IDbSettingProvider.class);
        for (String klass : impls) {
            IDbSettingProvider dsp = (IDbSettingProvider)App.getProxy().newInstance(klass);
            DB_SETTING_PROVIDERS.add(dsp);
        }
    }

    protected void buildExtra(Bean config, String key, String value) {
        Bean node = config;
        List<String> keys = StringUtil.list(key, "\\.");
        int last = keys.size() - 1;
        for (int i = 0; i < last; ++i) {
            String nodeKey = keys.get(i);
            Bean child = node.getBean(nodeKey);
            if (null == child) {
                child = new Bean();
                node.set(nodeKey, child);
            }
            node = child;
        }
        node.set(keys.get(last), value);
    }

    @Override
    public List<IDbSetting> listDbSettings() {
        HashMap<String, String> properties = new HashMap<String, String>(16);
        HashMap<String, Bean> settings = new HashMap<String, Bean>(16);
        for (String string : App.I18N) {
            ResourceBundle rb;
            try {
                rb = ResourceBundle.getBundle(string, Locale.getDefault());
            }
            catch (MissingResourceException e) {
                continue;
            }
            Enumeration<String> keys = rb.getKeys();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                if (!key.startsWith(SETTING_PREFIX)) continue;
                String value = rb.getString(key);
                properties.put(key, value);
                if (!key.equals(SETTING_PREFIX)) continue;
                for (String alias : StringUtil.list(value, ",")) {
                    if ((alias = alias.trim()).length() <= 0) continue;
                    settings.put(alias, new Bean(KEY_ALIAS, alias));
                }
            }
        }
        for (Map.Entry entry : settings.entrySet()) {
            String alias = (String)entry.getKey();
            Bean config = (Bean)entry.getValue();
            String prefix = String.format("%s.%s.", SETTING_PREFIX, alias);
            for (Map.Entry entry2 : properties.entrySet()) {
                String key = (String)entry2.getKey();
                if (!key.startsWith(prefix)) continue;
                this.buildExtra(config, StringUtil.right(key, prefix), (String)entry2.getValue());
            }
        }
        ArrayList<IDbSetting> l = new ArrayList<IDbSetting>();
        for (Bean o : settings.values()) {
            String type = o.getString(KEY_TYPE, "").toUpperCase();
            String alias = o.getString(KEY_ALIAS, "");
            boolean support = false;
            try {
                for (IDbSettingProvider dsp : DB_SETTING_PROVIDERS) {
                    if (!dsp.support(type)) continue;
                    l.add(dsp.buildDbSetting(o));
                    support = true;
                    break;
                }
            }
            catch (Exception exception) {
                throw new DaoException(App.getProperty("nlf.exception.dao.setting.format", alias), exception);
            }
            if (support) {
                logger.info(App.getProperty("nlf.dao.setting.provider.found", type, alias));
                continue;
            }
            logger.warn(App.getProperty("nlf.dao.setting.provider.not_found", alias, type));
        }
        return l;
    }

    static {
        PropertiesDbSettingManager.init();
    }
}

