/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.mini.extend.dao.sql.dbType.oracle;

import com.nlf.mini.Bean;
import com.nlf.mini.dao.paging.PageData;
import com.nlf.mini.extend.dao.sql.dbType.common.ASqlSelecter;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OracleSelecter
extends ASqlSelecter {
    private static final Logger logger = LoggerFactory.getLogger(OracleSelecter.class);

    @Override
    public boolean support(String dbType) {
        return "oracle".equalsIgnoreCase(dbType);
    }

    @Override
    public List<Bean> top(int count) {
        this.params.clear();
        this.sql = this.buildSql();
        this.sql = "SELECT * FROM (" + this.sql + ") WHERE ROWNUM <= " + count;
        logger.debug(this.buildLog());
        return this.queryList();
    }

    @Override
    public PageData page(int pageNumber, int pageSize) {
        PageData d = new PageData();
        d.setPageSize(pageSize);
        d.setPageNumber(pageNumber);
        d.setRecordCount(this.count());
        if (d.getPageNumber() > d.getPageCount()) {
            return d;
        }
        this.params.clear();
        this.sql = this.buildSql();
        this.sql = "SELECT * FROM (SELECT NLFTABLE_.*,ROWNUM RN_ FROM (" + this.sql + ") NLFTABLE_ WHERE ROWNUM <= " + d.getPageNumber() * d.getPageSize() + ") WHERE RN_ > " + (d.getPageNumber() - 1) * d.getPageSize();
        logger.debug(this.buildLog());
        List<Bean> l = this.queryList();
        d.setData(l);
        return d;
    }
}

