/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.mini.extend.dao.sql.dbType.sqlserver;

import com.nlf.mini.App;
import com.nlf.mini.Bean;
import com.nlf.mini.dao.exception.DaoException;
import com.nlf.mini.dao.paging.PageData;
import com.nlf.mini.extend.dao.sql.dbType.common.ASqlTemplate;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlserverTemplate
extends ASqlTemplate {
    private static final Logger logger = LoggerFactory.getLogger(SqlserverTemplate.class);

    @Override
    public boolean support(String dbType) {
        return "sqlserver".equalsIgnoreCase(dbType);
    }

    @Override
    public List<Bean> top(int count) {
        this.params.clear();
        String sql = this.buildSql();
        sql = "SELECT TOP " + count + sql.replaceFirst("SELECT", "");
        this.sql = sql = this.buildParams(sql, this.param);
        logger.debug(this.buildLog());
        return this.queryList();
    }

    @Override
    public int count() {
        this.params.clear();
        String sql = this.buildSql();
        sql = sql.replace("\r", " ").replace("\n", " ");
        String upperSql = sql.toUpperCase();
        int orderIndex = upperSql.indexOf(" ORDER ");
        if (orderIndex > -1) {
            sql = sql.substring(0, orderIndex);
        }
        sql = "SELECT COUNT(*) NLFCOUNT_ FROM (" + sql + ") NLFTABLE_";
        this.sql = sql = this.buildParams(sql, this.param);
        logger.debug(this.buildLog());
        List<Bean> l = this.queryList();
        if (l.size() < 1) {
            throw new DaoException(App.getProperty("nlf.exception.dao.select.one.not_found", new Object[0]));
        }
        Bean o = l.get(0);
        return o.getInt("NLFCOUNT_", 0);
    }

    @Override
    public PageData page(int pageNumber, int pageSize) {
        PageData d = new PageData();
        d.setPageSize(pageSize);
        d.setPageNumber(pageNumber);
        d.setRecordCount(this.count());
        if (d.getPageNumber() > d.getPageCount()) {
            return d;
        }
        this.params.clear();
        String sql = this.buildSql();
        sql = "SELECT TOP " + d.getPageNumber() * d.getPageSize() + sql.replaceFirst("SELECT", "");
        this.sql = sql = this.buildParams(sql, this.param);
        logger.debug(this.buildLog());
        List<Bean> l = this.queryList((d.getPageNumber() - 1) * d.getPageSize());
        d.setData(l);
        return d;
    }
}

