/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.mini.dao;

import com.nlf.mini.App;
import com.nlf.mini.dao.AbstractDao;
import com.nlf.mini.dao.DaoType;
import com.nlf.mini.dao.IDao;
import com.nlf.mini.dao.exception.DaoException;
import com.nlf.mini.dao.setting.DbSettingFactory;
import com.nlf.mini.dao.setting.IDbSetting;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DaoFactory {
    protected static final Map<String, String> DAOS = new HashMap<String, String>();

    public static IDao getDao(String alias) {
        if (!DAOS.containsKey(alias)) {
            IDbSetting setting = DbSettingFactory.getSetting(alias);
            List<String> impls = App.getImplements(IDao.class);
            for (String klass : impls) {
                AbstractDao dao = (AbstractDao)App.getProxy().newInstance(klass);
                if (!dao.support(setting.getDbType())) continue;
                DAOS.put(alias, klass);
                dao.init(alias);
                return dao;
            }
            DAOS.put(alias, null);
        } else {
            String impl = DAOS.get(alias);
            if (null != impl) {
                AbstractDao dao = (AbstractDao)App.getProxy().newInstance(impl);
                dao.init(alias);
                return dao;
            }
        }
        throw new DaoException(App.getProperty("nlf.exception.dao.not_found", alias));
    }

    public static IDao getDao() {
        return DaoFactory.getDao(DbSettingFactory.getDefaultSetting().getAlias());
    }

    public static IDao getDao(DaoType daoType) {
        return DaoFactory.getDao(DbSettingFactory.getDefaultSetting(daoType).getAlias());
    }
}

