/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.mini.extend.dao.sql;

import com.nlf.mini.App;
import com.nlf.mini.dao.exception.DaoException;
import com.nlf.mini.dao.transaction.AbstractTransaction;
import com.nlf.mini.extend.dao.sql.SqlConnection;
import com.nlf.mini.util.IOUtil;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class SqlTransaction
extends AbstractTransaction {
    @Override
    public void commit() {
        SqlConnection conn = (SqlConnection)this.connection;
        try {
            conn.getConnection().commit();
            conn.setInBatch(false);
        }
        catch (SQLException e) {
            throw new DaoException(e);
        }
    }

    @Override
    public void rollback() {
        SqlConnection conn = (SqlConnection)this.connection;
        try {
            conn.getConnection().rollback();
            conn.setInBatch(false);
        }
        catch (SQLException e) {
            throw new DaoException(e);
        }
    }

    @Override
    public void startBatch() {
        SqlConnection conn = (SqlConnection)this.connection;
        if (!conn.supportsBatchUpdates()) {
            throw new DaoException(App.getProperty("nlf.exception.dao.batch_not_support", conn.getDbSetting().getAlias()));
        }
        conn.setStatement(null);
        conn.setInBatch(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelBatch() {
        SqlConnection conn = (SqlConnection)this.connection;
        if (!conn.isInBatch()) {
            return;
        }
        PreparedStatement stmt = conn.getStatement();
        try {
            if (null != stmt) {
                stmt.clearBatch();
            }
        }
        catch (SQLException sQLException) {
        }
        finally {
            IOUtil.closeQuietly(stmt);
            conn.setInBatch(false);
        }
    }

    @Override
    public int[] executeBatch() {
        SqlConnection conn = (SqlConnection)this.connection;
        if (!conn.isInBatch()) {
            throw new DaoException(App.getProperty("nlf.exception.dao.batch_not_start", new Object[0]));
        }
        PreparedStatement stmt = conn.getStatement();
        int[] n = new int[]{};
        try {
            if (null != stmt) {
                n = stmt.executeBatch();
            }
        }
        catch (SQLException e) {
            throw new DaoException(e);
        }
        finally {
            IOUtil.closeQuietly(stmt);
            conn.setInBatch(false);
        }
        return n;
    }
}

