/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.mini.extend.dao.sql.dbType.common;

import com.nlf.mini.Bean;
import com.nlf.mini.extend.dao.sql.AbstractSqlExecuter;
import com.nlf.mini.extend.dao.sql.Condition;
import com.nlf.mini.extend.dao.sql.ISqlInserter;
import com.nlf.mini.util.StringUtil;

public class ASqlInserter
extends AbstractSqlExecuter
implements ISqlInserter {
    @Override
    public ISqlInserter table(String tables) {
        this.tables.add(tables);
        return this;
    }

    @Override
    public ISqlInserter tableIf(String tables, boolean condition) {
        if (condition) {
            this.table(tables);
        }
        return this;
    }

    @Override
    public String buildSql() {
        Condition r;
        int i;
        StringBuilder s = new StringBuilder();
        s.append("INSERT INTO ");
        s.append(StringUtil.join(this.tables, ","));
        s.append("(");
        int l = this.columns.size();
        for (i = 0; i < l; ++i) {
            s.append(i < 1 ? "" : ",");
            r = (Condition)this.columns.get(i);
            s.append(r.getColumn());
        }
        s.append(") VALUES(");
        int j = this.columns.size();
        for (i = 0; i < j; ++i) {
            s.append(i < 1 ? "" : ",");
            r = (Condition)this.columns.get(i);
            this.params.add(r.getValue());
            s.append(r.getStart());
            s.append(r.getPlaceholder());
            s.append(r.getEnd());
        }
        s.append(")");
        return s.toString();
    }

    @Override
    public int insert() {
        return this.executeUpdate();
    }

    @Override
    public Bean insertAndGetGenerated() {
        return this.executeUpdateAndGetGenerated();
    }

    @Override
    public ISqlInserter set(String column, Object value) {
        Condition cond = new Condition();
        cond.setColumn(column);
        cond.setValue(value);
        cond.setStart("");
        this.columns.add(cond);
        return this;
    }

    @Override
    public ISqlInserter set(Bean bean) {
        for (String key : bean.keySet()) {
            this.set(key, bean.get(key));
        }
        return this;
    }

    @Override
    public ISqlInserter setIf(String column, Object value, boolean condition) {
        if (condition) {
            this.set(column, value);
        }
        return this;
    }

    @Override
    public ISqlInserter setIf(Bean bean, boolean condition) {
        if (condition) {
            this.set(bean);
        }
        return this;
    }
}

