/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.mini.dao.connection;

import com.nlf.mini.App;
import com.nlf.mini.dao.connection.IConnectionProvider;
import com.nlf.mini.dao.exception.DaoException;
import com.nlf.mini.dao.setting.IDbSetting;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConnectionProvider
implements IConnectionProvider {
    private static final Logger logger = LoggerFactory.getLogger(AbstractConnectionProvider.class);
    protected static final Set<String> REGISTED_DRIVERS = new HashSet<String>();
    protected IDbSetting setting;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDbSetting(IDbSetting setting) {
        this.setting = setting;
        String driver = setting.getDriver();
        if (null == driver) {
            return;
        }
        AbstractConnectionProvider abstractConnectionProvider = this;
        synchronized (abstractConnectionProvider) {
            if (REGISTED_DRIVERS.contains(driver)) {
                return;
            }
            try {
                Class.forName(driver);
                REGISTED_DRIVERS.add(driver);
            }
            catch (ClassNotFoundException e) {
                throw new DaoException(App.getProperty("nlf.exception.dao.driver.not_found", driver), e);
            }
            logger.debug(App.getProperty("nlf.dao.driver.registed", driver));
        }
    }
}

