/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.mini;

import com.nlf.mini.core.IProxy;
import com.nlf.mini.core.ScannerFactory;
import com.nlf.mini.core.impl.DefaultProxy;
import com.nlf.mini.dao.paging.impl.DefaultPagingRender;
import com.nlf.mini.dao.setting.impl.PropertiesDbSettingManager;
import com.nlf.mini.extend.dao.sql.dbType.common.ASqlDeleter;
import com.nlf.mini.extend.dao.sql.dbType.common.ASqlInserter;
import com.nlf.mini.extend.dao.sql.dbType.common.ASqlJoiner;
import com.nlf.mini.extend.dao.sql.dbType.common.ASqlSelecter;
import com.nlf.mini.extend.dao.sql.dbType.common.ASqlTemplate;
import com.nlf.mini.extend.dao.sql.dbType.common.ASqlUpdater;
import com.nlf.mini.extend.dao.sql.dbType.mysql.MysqlDao;
import com.nlf.mini.extend.dao.sql.dbType.mysql.MysqlSelecter;
import com.nlf.mini.extend.dao.sql.dbType.mysql.MysqlTemplate;
import com.nlf.mini.extend.dao.sql.dbType.oracle.OracleDao;
import com.nlf.mini.extend.dao.sql.dbType.oracle.OracleSelecter;
import com.nlf.mini.extend.dao.sql.dbType.oracle.OracleTemplate;
import com.nlf.mini.extend.dao.sql.dbType.sqlserver.SqlserverDao;
import com.nlf.mini.extend.dao.sql.dbType.sqlserver.SqlserverSelecter;
import com.nlf.mini.extend.dao.sql.dbType.sqlserver.SqlserverTemplate;
import com.nlf.mini.extend.dao.sql.type.jdbc.JdbcConnectionProvider;
import com.nlf.mini.extend.dao.sql.type.jdbc.JdbcSettingProvider;
import com.nlf.mini.extend.serialize.obj.impl.DefaultObjParser;
import com.nlf.mini.extend.serialize.obj.impl.DefaultObjWrapper;
import com.nlf.mini.extend.serialize.xml.impl.DefaultXmlParser;
import com.nlf.mini.extend.serialize.xml.impl.DefaultXmlWrapper;
import com.nlf.mini.plugin.IPlugin;
import com.nlf.mini.resource.i18n.I18nResource;
import com.nlf.mini.resource.klass.comparator.ClassComparator;
import com.nlf.mini.serialize.json.impl.DefaultJsonParser;
import com.nlf.mini.serialize.json.impl.DefaultJsonWrapper;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;

public class App {
    public static Locale locale = Locale.getDefault();
    public static String root;
    public static String caller;
    public static String frame;
    public static String profile;
    private static final String OBJECT_CLASS_NAME;
    private static volatile IProxy proxy;
    public static final Set<String> DIRECTORIES;
    public static final Set<String> I18N;
    public static final String PACKAGE;
    public static final List<I18nResource> I18N_RESOURCE;
    protected static ClassComparator classComparator;
    public static final Map<String, List<String>> INTERFACE_IMPLEMENTS;
    public static final Set<String> plugins;

    protected App() {
    }

    protected static void applyPlugins() {
        for (String c : plugins) {
            IPlugin p = null;
            try {
                p = (IPlugin)proxy.newInstance(c);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (null == p) continue;
            p.onApply();
        }
    }

    protected static Set<String> getInterfaces(Class<?> klass) {
        HashSet<String> interfaces = new HashSet<String>();
        for (Class<?> i : klass.getInterfaces()) {
            interfaces.add(i.getName());
            interfaces.addAll(App.getInterfaces(i));
        }
        Class<?> superClass = klass.getSuperclass();
        if (null != superClass && !OBJECT_CLASS_NAME.equals(superClass.getName())) {
            interfaces.addAll(App.getInterfaces(superClass));
        }
        return interfaces;
    }

    public static void addImplement(Class<?> klass) {
        String className = klass.getName();
        String proxyName = IProxy.class.getName();
        for (String interfaceName : App.getInterfaces(klass)) {
            List impls = INTERFACE_IMPLEMENTS.computeIfAbsent(interfaceName, k -> new ArrayList());
            if (!impls.contains(className)) {
                impls.add(className);
            }
            impls.sort(classComparator);
            if (!proxyName.equals(interfaceName)) continue;
            proxy = (IProxy)new DefaultProxy().newInstance(proxyName);
        }
    }

    public static String getProperty(String key, Object ... params) {
        return App.getProperty(locale, key, params);
    }

    public static String getProperty(Locale locale, String key, Object ... params) {
        String value = null;
        String baseName = null;
        for (String i18n : I18N) {
            try {
                value = ResourceBundle.getBundle(i18n, locale).getString(key);
                baseName = i18n;
                break;
            }
            catch (Exception exception) {
            }
        }
        if (null != profile && null != baseName) {
            try {
                value = ResourceBundle.getBundle(baseName + "-" + profile, locale).getString(key);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null == value ? null : (params.length > 0 ? MessageFormat.format(value, params) : value);
    }

    public static short getPropertyShort(String key, short defaultValue) {
        try {
            return Short.parseShort(App.getProperty(key, new Object[0]));
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static int getPropertyInt(String key, int defaultValue) {
        try {
            return Integer.parseInt(App.getProperty(key, new Object[0]));
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static long getPropertyLong(String key, long defaultValue) {
        try {
            return Long.parseLong(App.getProperty(key, new Object[0]));
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static float getPropertyFloat(String key, float defaultValue) {
        try {
            return Float.parseFloat(App.getProperty(key, new Object[0]));
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static double getPropertyDouble(String key, double defaultValue) {
        try {
            return Double.parseDouble(App.getProperty(key, new Object[0]));
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static boolean getPropertyBoolean(String key, boolean defaultValue) {
        try {
            String value = App.getProperty(key, new Object[0]);
            return null == value ? defaultValue : Boolean.parseBoolean(value);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static String getPropertyString(String key, String defaultValue) {
        try {
            String ret = App.getProperty(key, new Object[0]);
            return null == ret ? defaultValue : ret;
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static String getPropertyString(Locale locale, String key, String defaultValue) {
        try {
            String ret = App.getProperty(locale, key, new Object[0]);
            return null == ret ? defaultValue : ret;
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static IProxy getProxy() {
        return proxy;
    }

    public static List<String> getImplements(String ... interfaceOrClassNames) {
        ArrayList<String> l = null;
        for (String name : interfaceOrClassNames) {
            ArrayList<String> sub = new ArrayList<String>();
            List<String> impls = INTERFACE_IMPLEMENTS.get(name);
            if (null != impls) {
                sub.addAll(impls);
            } else {
                sub.add(name);
            }
            if (null == l) {
                l = sub;
                continue;
            }
            l.retainAll(sub);
        }
        return l;
    }

    public static List<String> getImplements(Class<?> ... interfaceOrClasses) {
        ArrayList<String> l = new ArrayList<String>();
        for (Class<?> c : interfaceOrClasses) {
            l.add(c.getName());
        }
        String[] arr = new String[l.size()];
        l.toArray(arr);
        return App.getImplements(arr);
    }

    public static String getImplement(String ... interfaceOrClassNames) {
        List<String> impls = App.getImplements(interfaceOrClassNames);
        return impls.size() < 1 ? null : impls.get(0);
    }

    public static String getImplement(Class<?> ... interfaceOrClasses) {
        List<String> impls = App.getImplements(interfaceOrClasses);
        return impls.size() < 1 ? null : impls.get(0);
    }

    static {
        OBJECT_CLASS_NAME = Object.class.getName();
        DIRECTORIES = new LinkedHashSet<String>();
        I18N = new LinkedHashSet<String>();
        PACKAGE = App.class.getPackage().getName();
        I18N_RESOURCE = new ArrayList<I18nResource>();
        classComparator = new ClassComparator();
        INTERFACE_IMPLEMENTS = new HashMap<String, List<String>>();
        plugins = new HashSet<String>();
        ScannerFactory.startScan();
        App.addImplement(DefaultProxy.class);
        App.addImplement(DefaultJsonParser.class);
        App.addImplement(DefaultJsonWrapper.class);
        App.addImplement(DefaultXmlParser.class);
        App.addImplement(DefaultXmlWrapper.class);
        App.addImplement(DefaultObjParser.class);
        App.addImplement(DefaultObjWrapper.class);
        App.addImplement(DefaultPagingRender.class);
        App.addImplement(PropertiesDbSettingManager.class);
        App.addImplement(JdbcSettingProvider.class);
        App.addImplement(JdbcConnectionProvider.class);
        App.addImplement(MysqlDao.class);
        App.addImplement(OracleDao.class);
        App.addImplement(SqlserverDao.class);
        App.addImplement(MysqlSelecter.class);
        App.addImplement(OracleSelecter.class);
        App.addImplement(SqlserverSelecter.class);
        App.addImplement(ASqlSelecter.class);
        App.addImplement(ASqlInserter.class);
        App.addImplement(ASqlUpdater.class);
        App.addImplement(ASqlDeleter.class);
        App.addImplement(ASqlJoiner.class);
        App.addImplement(MysqlTemplate.class);
        App.addImplement(OracleTemplate.class);
        App.addImplement(SqlserverTemplate.class);
        App.addImplement(ASqlTemplate.class);
        App.applyPlugins();
    }
}

