/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.mini.dao.connection;

import com.nlf.mini.App;
import com.nlf.mini.dao.connection.IConnection;
import com.nlf.mini.dao.connection.IConnectionProvider;
import com.nlf.mini.dao.exception.DaoException;
import com.nlf.mini.dao.setting.DbSettingFactory;
import com.nlf.mini.dao.setting.IDbSetting;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ConnectionFactory {
    protected static final Map<String, IConnectionProvider> POOL = new HashMap<String, IConnectionProvider>();

    protected ConnectionFactory() {
    }

    public static IConnection getConnection(String alias) {
        IDbSetting setting = DbSettingFactory.getSetting(alias);
        String type = setting.getType();
        if (!POOL.containsKey(alias)) {
            List<String> impls = App.getImplements(IConnectionProvider.class);
            for (String impl : impls) {
                IConnectionProvider p = (IConnectionProvider)App.getProxy().newInstance(impl);
                if (!p.support(type)) continue;
                POOL.put(alias, p);
                p.setDbSetting(setting);
                return p.getConnection();
            }
            POOL.put(alias, null);
        } else {
            IConnectionProvider p = POOL.get(alias);
            if (null != p) {
                return p.getConnection();
            }
        }
        throw new DaoException(App.getProperty("nlf.exception.dao.connection.provider.not_found", type));
    }

    public static IConnection getConnection() {
        return ConnectionFactory.getConnection(DbSettingFactory.getDefaultSetting().getAlias());
    }
}

