/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.mini.logger.impl;

import com.nlf.mini.App;
import com.nlf.mini.logger.AbstractLogger;
import com.nlf.mini.util.DateUtil;

public class DefaultLogger
extends AbstractLogger {
    public static final String KLASS = DefaultLogger.class.getName();

    public DefaultLogger(String name) {
        super(name);
    }

    private StackTraceElement findStackTrace() {
        StackTraceElement[] sts;
        int index = 0;
        for (StackTraceElement st : sts = Thread.currentThread().getStackTrace()) {
            if (KLASS.equals(st.getClassName())) {
                index += 2;
                break;
            }
            ++index;
        }
        return sts[index];
    }

    @Override
    public void debug(String s) {
        if (this.enable) {
            System.out.println(App.getProperty("nlf.log.default.debug", DateUtil.ymdhms(DateUtil.now()), this.name, this.findStackTrace(), s));
        }
    }

    @Override
    public void info(String s) {
        if (this.enable) {
            System.out.println(App.getProperty("nlf.log.default.info", DateUtil.ymdhms(DateUtil.now()), this.name, this.findStackTrace(), s));
        }
    }

    @Override
    public void warn(String s) {
        if (this.enable) {
            System.out.println(App.getProperty("nlf.log.default.warn", DateUtil.ymdhms(DateUtil.now()), this.name, this.findStackTrace(), s));
        }
    }
}

