/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.mini.extend.dao.sql;

import com.nlf.mini.App;
import com.nlf.mini.Bean;
import com.nlf.mini.dao.exception.DaoException;
import com.nlf.mini.dao.executer.AbstractDaoExecuter;
import com.nlf.mini.extend.dao.sql.Condition;
import com.nlf.mini.extend.dao.sql.ConditionType;
import com.nlf.mini.extend.dao.sql.ISqlExecuter;
import com.nlf.mini.extend.dao.sql.ResultSetIterator;
import com.nlf.mini.extend.dao.sql.SqlConnection;
import com.nlf.mini.logger.ILogger;
import com.nlf.mini.logger.LoggerFactory;
import com.nlf.mini.util.IOUtil;
import com.nlf.mini.util.StringUtil;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class AbstractSqlExecuter
extends AbstractDaoExecuter
implements ISqlExecuter {
    private static final ILogger logger = LoggerFactory.getLogger(AbstractSqlExecuter.class);
    protected String sql;
    protected List<Object> params = new ArrayList<Object>();
    protected List<String> tables = new ArrayList<String>();
    protected List<Condition> columns = new ArrayList<Condition>();
    protected List<String> groupBys = new ArrayList<String>();
    protected List<String> sorts = new ArrayList<String>();
    protected List<Condition> wheres = new ArrayList<Condition>();
    protected List<Condition> havings = new ArrayList<Condition>();
    protected static Pattern namedPlaceHolderPattern = Pattern.compile(":\\w+");
    protected static Pattern onPattern = Pattern.compile("\\w+(?=\\.)");
    protected static Comparator<String> keyComparator = (a, b) -> b.length() - a.length();
    public static final String PLACEHOLDER = "?";
    public static final String PLACEHOLDER_REG = "\\?";
    public static final String NAMED_PLACEHOLDER_PREFIX = ":";

    @Override
    public boolean support(String dbType) {
        return true;
    }

    protected String buildLog() {
        StringBuilder s = new StringBuilder();
        s.append(App.getProperty("nlf.dao.executer.sql.statement", this.sql));
        int j = this.params.size();
        for (int i = 0; i < j; ++i) {
            s.append(App.getProperty("nlf.dao.executer.sql.parameter", i, this.params.get(i)));
        }
        return s.toString();
    }

    protected List<Bean> toBeans(ResultSet rs) throws SQLException {
        ArrayList<Bean> l = new ArrayList<Bean>();
        ResultSetMetaData md = rs.getMetaData();
        while (rs.next()) {
            Bean o = new Bean();
            int j = md.getColumnCount();
            for (int i = 1; i <= j; ++i) {
                o.set(md.getColumnLabel(i), rs.getObject(i));
            }
            l.add(o);
        }
        return l;
    }

    protected List<Bean> queryList() {
        return this.queryList(0);
    }

    protected List<Bean> queryList(int row) {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.prepareStatement((SqlConnection)this.connection);
            rs = stmt.executeQuery();
            if (row > 0) {
                rs.absolute(row);
            }
            List<Bean> list = this.toBeans(rs);
            this.finalize(stmt, rs);
            return list;
        }
        catch (SQLException e) {
            try {
                throw new DaoException(e);
            }
            catch (Throwable throwable) {
                this.finalize(stmt, rs);
                throw throwable;
            }
        }
    }

    public Iterator<Bean> queryIterator() {
        ResultSetIterator iterator;
        PreparedStatement stmt = null;
        try {
            stmt = this.prepareStatement((SqlConnection)this.connection);
            ResultSet rs = stmt.executeQuery();
            iterator = new ResultSetIterator(rs);
        }
        catch (SQLException e) {
            this.finalize(stmt);
            throw new DaoException(e);
        }
        return iterator;
    }

    protected void finalize(Statement stmt, ResultSet rs) {
        IOUtil.closeQuietly(rs);
        IOUtil.closeQuietly(stmt);
    }

    protected void finalize(Statement stmt) {
        this.finalize(stmt, null);
    }

    protected void bindParams(PreparedStatement stmt) throws SQLException {
        int j = this.params.size();
        for (int i = 1; i <= j; ++i) {
            Object p = this.params.get(i - 1);
            if (p instanceof Timestamp) {
                stmt.setTimestamp(i, (Timestamp)p);
                continue;
            }
            if (p instanceof Date) {
                stmt.setDate(i, (Date)p);
                continue;
            }
            if (p instanceof java.util.Date) {
                java.util.Date dd = (java.util.Date)p;
                stmt.setDate(i, new Date(dd.getTime()));
                continue;
            }
            stmt.setObject(i, p);
        }
    }

    protected String buildParams(String sql, Bean o) {
        if (null == o) {
            return sql;
        }
        if (sql.length() < 1) {
            return sql;
        }
        if (!sql.contains(NAMED_PLACEHOLDER_PREFIX)) {
            return sql;
        }
        ArrayList<String> keys = new ArrayList<String>();
        Matcher m = namedPlaceHolderPattern.matcher(sql);
        while (m.find()) {
            String key = m.group();
            if (!keys.contains(key)) {
                keys.add(key);
            }
            this.params.add(o.get(key.substring(1)));
        }
        keys.sort(keyComparator);
        String newSql = sql;
        for (String key : keys) {
            newSql = newSql.replace(key, PLACEHOLDER);
        }
        return newSql;
    }

    protected void buildParams(List<Condition> l) {
        for (Condition c : l) {
            switch (c.getType()) {
                case one_param: {
                    this.params.add(c.getValue());
                    break;
                }
                case pure_sql: {
                    break;
                }
                case multi_params: {
                    Bean o = (Bean)c.getValue();
                    this.buildParams(c.getColumn(), o);
                    this.buildParams(c.getStart(), o);
                    this.buildParams(c.getPlaceholder(), o);
                    this.buildParams(c.getEnd(), o);
                    break;
                }
            }
        }
    }

    @Override
    public String getSql() {
        if (null == this.sql) {
            this.sql = this.buildSql();
        }
        return this.sql;
    }

    @Override
    public List<Object> getParams() {
        return this.params;
    }

    protected Condition buildPureSqlCondition(String sql) {
        return new Condition(ConditionType.pure_sql, sql, "", "", null, "");
    }

    protected ISqlExecuter where(String sql) {
        this.wheres.add(this.buildPureSqlCondition(sql));
        return this;
    }

    protected ISqlExecuter where(String columnOrSql, Object valueOrBean) {
        Condition cond = new Condition();
        cond.setColumn(columnOrSql);
        if (null == valueOrBean) {
            cond.setStart(" IS");
            cond.setPlaceholder(" NULL");
            cond.setType(ConditionType.pure_sql);
        } else if (columnOrSql.contains(NAMED_PLACEHOLDER_PREFIX)) {
            Bean value;
            if (valueOrBean instanceof Bean) {
                value = (Bean)valueOrBean;
            } else if (valueOrBean instanceof Map) {
                Map map = (Map)valueOrBean;
                value = new Bean();
                for (Map.Entry entry : map.entrySet()) {
                    value.set(entry.getKey() + "", entry.getValue());
                }
            } else {
                value = new Bean();
                Matcher m = namedPlaceHolderPattern.matcher(columnOrSql);
                while (m.find()) {
                    String key = m.group().substring(1);
                    value.set(key, valueOrBean);
                }
            }
            cond.setStart("");
            cond.setPlaceholder("");
            cond.setEnd("");
            cond.setValue(value);
            cond.setType(ConditionType.multi_params);
        } else if (columnOrSql.contains(PLACEHOLDER)) {
            int count;
            Object l;
            boolean singleValue = false;
            Bean value = new Bean();
            if (valueOrBean.getClass().isArray()) {
                l = (Object[])valueOrBean;
                int j = ((Object[])l).length;
                for (int i = 0; i < j; ++i) {
                    value.set("_" + i, l[i]);
                }
            } else if (valueOrBean instanceof Collection) {
                l = (Collection)valueOrBean;
                count = 0;
                Iterator j = l.iterator();
                while (j.hasNext()) {
                    Object o = j.next();
                    value.set("_" + count++, o);
                }
            } else {
                singleValue = true;
            }
            String newSql = columnOrSql;
            count = 0;
            while (newSql.contains(PLACEHOLDER)) {
                String key = "_" + count++;
                newSql = newSql.replaceFirst(PLACEHOLDER_REG, NAMED_PLACEHOLDER_PREFIX + key);
                if (!singleValue) continue;
                value.set(key, valueOrBean);
            }
            cond.setColumn(newSql);
            cond.setStart("");
            cond.setPlaceholder("");
            cond.setEnd("");
            cond.setValue(value);
            cond.setType(ConditionType.multi_params);
        } else {
            cond.setValue(valueOrBean);
        }
        this.wheres.add(cond);
        return this;
    }

    protected ISqlExecuter whereNotEqual(String column, Object value) {
        Condition cond = new Condition();
        cond.setColumn(column);
        if (null == value) {
            cond.setStart(" IS NOT");
            cond.setPlaceholder(" NULL");
            cond.setType(ConditionType.pure_sql);
        } else {
            cond.setStart("!=");
            cond.setValue(value);
        }
        this.wheres.add(cond);
        return this;
    }

    protected ISqlExecuter whereIf(String sql, boolean condition) {
        if (condition) {
            this.where(sql);
        }
        return this;
    }

    protected ISqlExecuter whereIf(String column, Object value, boolean condition) {
        if (condition) {
            this.where(column, value);
        }
        return this;
    }

    protected ISqlExecuter whereIf(String sql, Bean values, boolean condition) {
        if (condition) {
            this.where(sql, values);
        }
        return this;
    }

    protected ISqlExecuter whereIn(String column, Object ... values) {
        if (1 == values.length) {
            return this.where(column, values[0]);
        }
        Bean param = new Bean();
        String placeholder = this.buildSqlIn(column, param, values);
        this.wheres.add(new Condition(ConditionType.multi_params, column, " IN(", placeholder, param, ")"));
        return this;
    }

    protected ISqlExecuter whereNotIn(String column, Object ... values) {
        if (1 == values.length) {
            Object v = values[0];
            if (null == v) {
                return this.where(column + " IS NOT NULL");
            }
            return this.where(column + " != :" + column, new Bean(column, v));
        }
        Bean param = new Bean();
        String placeholder = this.buildSqlIn(column, param, values);
        this.wheres.add(new Condition(ConditionType.multi_params, column, " NOT IN(", placeholder, param, ")"));
        return this;
    }

    protected abstract String buildSql();

    protected String buildSqlIn(String column, Bean param, Object ... values) {
        StringBuilder s = new StringBuilder();
        int i = 0;
        for (Object v : values) {
            if (i > 0) {
                s.append(",");
            }
            String key = column.replaceAll("\\W", "") + "_" + i;
            s.append(NAMED_PLACEHOLDER_PREFIX);
            s.append(key);
            param.set(key, v);
            ++i;
        }
        return s.toString();
    }

    protected String buildSqlParams(Condition r) {
        StringBuilder s = new StringBuilder();
        switch (r.getType()) {
            case one_param: {
                this.params.add(r.getValue());
            }
            case pure_sql: {
                s.append(r.getColumn());
                s.append(r.getStart());
                s.append(r.getPlaceholder());
                s.append(r.getEnd());
                break;
            }
            case multi_params: {
                Bean o = (Bean)r.getValue();
                s.append(this.buildParams(r.getColumn(), o));
                s.append(this.buildParams(r.getStart(), o));
                s.append(this.buildParams(r.getPlaceholder(), o));
                s.append(this.buildParams(r.getEnd(), o));
                break;
            }
        }
        return s.toString();
    }

    protected String buildSqlWhere() {
        StringBuilder s = new StringBuilder();
        int l = this.wheres.size();
        for (int i = 0; i < l; ++i) {
            s.append(" ");
            s.append(i < 1 ? "WHERE" : "AND");
            s.append(" ");
            s.append(this.buildSqlParams(this.wheres.get(i)));
        }
        return s.toString();
    }

    protected String buildTables() {
        StringBuilder s = new StringBuilder();
        HashSet<String> onAliases = new HashSet<String>();
        HashSet<String> existAliases = new HashSet<String>();
        HashMap<String, String> joinTables = new HashMap<String, String>(8);
        HashMap<String, String> notJoinTables = new HashMap<String, String>(8);
        HashMap ons = new HashMap(8);
        for (String string : this.tables) {
            if (string.startsWith("*ON ")) {
                HashSet<String> aliases = new HashSet<String>();
                Matcher m = onPattern.matcher(string);
                while (m.find()) {
                    String alias = m.group().toUpperCase();
                    aliases.add(alias);
                    onAliases.add(alias);
                }
                ons.put(string, aliases);
                continue;
            }
            if (string.startsWith("*") && string.contains(" JOIN ")) {
                String name;
                String alias = name = StringUtil.right(string, " JOIN ").toUpperCase();
                if (name.contains(" AS ")) {
                    alias = StringUtil.right(name, " AS ");
                } else if (name.contains(" ")) {
                    alias = StringUtil.right(name, " ");
                }
                alias = alias.trim();
                joinTables.put(alias, string);
                continue;
            }
            String alias = string;
            if (string.contains(" AS ")) {
                alias = StringUtil.right(string, " AS ");
            } else if (string.contains(" ")) {
                alias = StringUtil.right(string, " ");
            }
            alias = alias.toUpperCase().trim();
            existAliases.add(alias);
            notJoinTables.put(string, alias);
        }
        for (Map.Entry entry : notJoinTables.entrySet()) {
            if (onAliases.contains(entry.getValue())) continue;
            if (s.length() > 0) {
                s.append(", ");
            }
            s.append((String)entry.getKey());
        }
        for (Map.Entry entry : notJoinTables.entrySet()) {
            if (!onAliases.contains(entry.getValue())) continue;
            if (s.length() > 0) {
                s.append(", ");
            }
            s.append((String)entry.getKey());
        }
        while (!ons.isEmpty()) {
            HashSet<String> already = new HashSet<String>();
            for (Map.Entry on : ons.entrySet()) {
                int notMatched = 0;
                Set value = (Set)on.getValue();
                for (String alias : value) {
                    if (existAliases.contains(alias)) continue;
                    ++notMatched;
                }
                if (notMatched > 1) continue;
                for (String alias : value) {
                    String table = (String)joinTables.remove(alias);
                    if (null == table) continue;
                    s.append(" ");
                    s.append(table.substring(1));
                    existAliases.add(alias);
                }
                String key = (String)on.getKey();
                s.append(" ");
                s.append(key.substring(1));
                already.add(key);
            }
            for (String key : already) {
                ons.remove(key);
            }
        }
        return s.toString();
    }

    protected PreparedStatement prepareStatement(SqlConnection conn) throws SQLException {
        return this.prepareStatement(conn, false);
    }

    protected PreparedStatement prepareStatement(SqlConnection conn, boolean generatedKeys) throws SQLException {
        PreparedStatement stmt;
        if (!conn.isInBatch()) {
            stmt = !generatedKeys ? conn.getConnection().prepareStatement(this.sql) : conn.getConnection().prepareStatement(this.sql, 1);
        } else {
            stmt = conn.getStatement();
            if (null != stmt) {
                stmt.clearParameters();
                if (!this.sql.equals(conn.getSql())) {
                    throw new DaoException(App.getProperty("nlf.exception.dao.batch_sql_not_match", new Object[0]));
                }
            } else {
                stmt = conn.getConnection().prepareStatement(this.sql);
                conn.setStatement(stmt);
                conn.setSql(this.sql);
            }
        }
        this.bindParams(stmt);
        return stmt;
    }

    protected int executeUpdate() {
        this.params.clear();
        this.sql = this.buildSql();
        logger.debug(this.buildLog());
        PreparedStatement stmt = null;
        SqlConnection conn = null;
        try {
            conn = (SqlConnection)this.connection;
            stmt = this.prepareStatement(conn);
            if (conn.isInBatch()) {
                stmt.addBatch();
                int n = -1;
                return n;
            }
            int n = stmt.executeUpdate();
            return n;
        }
        catch (SQLException e) {
            throw new DaoException(e);
        }
        finally {
            if (!conn.isInBatch()) {
                this.finalize(stmt);
            }
        }
    }

    protected Bean executeUpdateAndGetGenerated() {
        Bean ret = new Bean();
        this.params.clear();
        this.sql = this.buildSql();
        logger.debug(this.buildLog());
        PreparedStatement stmt = null;
        SqlConnection conn = null;
        try {
            Object rs;
            conn = (SqlConnection)this.connection;
            stmt = this.prepareStatement(conn, true);
            if (conn.isInBatch()) {
                stmt.addBatch();
            } else {
                stmt.executeUpdate();
                rs = stmt.getGeneratedKeys();
                List<Bean> l = this.toBeans((ResultSet)rs);
                if (!l.isEmpty()) {
                    ret = l.get(0);
                }
            }
            rs = ret;
            if (!conn.isInBatch()) {
                this.finalize(stmt);
            }
            return rs;
        }
        catch (SQLException e) {
            try {
                throw new DaoException(e);
            }
            catch (Throwable throwable) {
                if (!conn.isInBatch()) {
                    this.finalize(stmt);
                }
                throw throwable;
            }
        }
    }
}

