/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.mini.extend.dao.sql.dbType.mysql;

import com.nlf.mini.Bean;
import com.nlf.mini.dao.paging.PageData;
import com.nlf.mini.extend.dao.sql.dbType.common.ASqlSelecter;
import com.nlf.mini.logger.ILogger;
import com.nlf.mini.logger.LoggerFactory;
import java.util.List;

public class MysqlSelecter
extends ASqlSelecter {
    private static final ILogger logger = LoggerFactory.getLogger(MysqlSelecter.class);

    @Override
    public boolean support(String dbType) {
        return "mysql".equalsIgnoreCase(dbType);
    }

    @Override
    public List<Bean> top(int count) {
        this.params.clear();
        this.sql = this.buildSql();
        this.sql = this.sql + " LIMIT 0," + count;
        logger.debug(this.buildLog());
        return this.queryList();
    }

    @Override
    public PageData page(int pageNumber, int pageSize) {
        PageData d = new PageData();
        d.setPageSize(pageSize);
        d.setPageNumber(pageNumber);
        d.setRecordCount(this.count());
        if (d.getPageNumber() > d.getPageCount()) {
            return d;
        }
        this.params.clear();
        this.sql = this.buildSql();
        this.sql = this.sql + " LIMIT " + (d.getPageNumber() - 1) * d.getPageSize() + "," + d.getPageSize();
        logger.debug(this.buildLog());
        List<Bean> l = this.queryList();
        d.setData(l);
        return d;
    }
}

