/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.mini.extend.dao.sql.dbType.oracle;

import com.nlf.mini.Bean;
import com.nlf.mini.dao.paging.PageData;
import com.nlf.mini.extend.dao.sql.dbType.common.ASqlTemplate;
import com.nlf.mini.logger.ILogger;
import com.nlf.mini.logger.LoggerFactory;
import java.util.List;

public class OracleTemplate
extends ASqlTemplate {
    private static final ILogger logger = LoggerFactory.getLogger(OracleTemplate.class);

    @Override
    public boolean support(String dbType) {
        return "oracle".equalsIgnoreCase(dbType);
    }

    @Override
    public List<Bean> top(int count) {
        this.params.clear();
        String sql = this.buildSql();
        sql = "SELECT * FROM (" + sql + ") WHERE ROWNUM <= " + count;
        this.sql = sql = this.buildParams(sql, this.param);
        logger.debug(this.buildLog());
        return this.queryList();
    }

    @Override
    public PageData page(int pageNumber, int pageSize) {
        PageData d = new PageData();
        d.setPageSize(pageSize);
        d.setPageNumber(pageNumber);
        d.setRecordCount(this.count());
        if (d.getPageNumber() > d.getPageCount()) {
            return d;
        }
        this.params.clear();
        String sql = this.buildSql();
        sql = "SELECT * FROM (SELECT NLFTABLE_.*,ROWNUM RN_ FROM (" + sql + ") NLFTABLE_ WHERE ROWNUM <= " + d.getPageNumber() * d.getPageSize() + ") WHERE RN_ > " + (d.getPageNumber() - 1) * d.getPageSize();
        this.sql = sql = this.buildParams(sql, this.param);
        logger.debug(this.buildLog());
        List<Bean> l = this.queryList();
        d.setData(l);
        return d;
    }
}

