/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.mini.logger;

import com.nlf.mini.App;
import com.nlf.mini.core.IProxy;
import com.nlf.mini.logger.ILogger;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public abstract class AbstractLogger
implements ILogger {
    protected String name;
    protected Object logger;
    protected IProxy proxy;

    protected AbstractLogger(String name) {
        this.name = name;
        this.proxy = App.getProxy();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void debug(String s) {
        if (null != this.logger) {
            try {
                Method m = this.logger.getClass().getMethod("debug", String.class);
                m.invoke(this.logger, s);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void info(String s) {
        if (null != this.logger) {
            try {
                Method m = this.logger.getClass().getMethod("info", String.class);
                m.invoke(this.logger, s);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void warn(String s) {
        if (null != this.logger) {
            try {
                Method m = this.logger.getClass().getMethod("warn", String.class);
                m.invoke(this.logger, s);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

