/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.mini.logger;

import com.nlf.mini.App;
import com.nlf.mini.logger.AbstractLogger;
import com.nlf.mini.logger.ILogger;
import com.nlf.mini.logger.LoggerType;
import com.nlf.mini.logger.impl.CommonsLoggingLogger;
import com.nlf.mini.logger.impl.DefaultLogger;
import com.nlf.mini.logger.impl.NoLogger;
import com.nlf.mini.logger.impl.Slf4jLogger;

public class LoggerFactory {
    protected static String[] active;
    protected static LoggerType loggerType;

    private LoggerFactory() {
    }

    public static ILogger getLogger(Class<?> clazz) {
        AbstractLogger logger;
        String name = clazz.getName();
        if (null != loggerType) {
            switch (loggerType) {
                case SLF4J: {
                    logger = new Slf4jLogger(name);
                    break;
                }
                case COMMONS_LOGGING: {
                    logger = new CommonsLoggingLogger(name);
                    break;
                }
                default: {
                    logger = new DefaultLogger(name);
                    break;
                }
            }
        } else {
            logger = new NoLogger(name);
        }
        return logger;
    }

    static {
        for (String type : active = App.getPropertyString("nlf.logger.active", "").replace("\"", "").replace("'", "").split(",")) {
            if ((type = type.trim()).equalsIgnoreCase(LoggerType.DEFAULT.name())) {
                loggerType = LoggerType.DEFAULT;
                break;
            }
            if (type.equalsIgnoreCase(LoggerType.SLF4J.name())) {
                try {
                    Class.forName("org.slf4j.LoggerFactory");
                    loggerType = LoggerType.SLF4J;
                    break;
                }
                catch (Exception exception) {
                    continue;
                }
            }
            if (!type.equalsIgnoreCase(LoggerType.COMMONS_LOGGING.name())) continue;
            try {
                Class.forName("org.apache.commons.logging.LogFactory");
                loggerType = LoggerType.COMMONS_LOGGING;
                break;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

