/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.extend.model;

import com.nlf.Bean;
import com.nlf.core.AbstractBean;
import com.nlf.extend.dao.sql.ISqlDeleter;
import com.nlf.extend.dao.sql.ISqlSelecter;
import com.nlf.extend.dao.sql.ISqlUpdater;
import com.nlf.extend.dao.sql.SqlDaoFactory;
import com.nlf.extend.model.IModelSelecter;
import com.nlf.extend.model.impl.DefaultModelSelecter;
import com.nlf.serialize.json.JSON;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Model<M extends Model>
extends AbstractBean {
    public static final String DEFAULT_PRIMARY_KEY = "id";
    protected String alias;
    protected String tableName;
    protected Set<String> primaryKeys = new LinkedHashSet<String>();
    protected String autoIncrement;
    protected Bean cache;
    protected IModelSelecter<M> selecter;

    protected Model() {
    }

    protected Model(String tableName, String primaryKey) {
        this(tableName, primaryKey, null);
    }

    protected Model(String[] primaryKeys, String autoIncrement) {
        this(null, primaryKeys, autoIncrement);
    }

    protected Model(String tableName, String primaryKey, String autoIncrement) {
        this(tableName, new String[]{primaryKey}, autoIncrement);
    }

    protected Model(String tableName) {
        this(tableName, new String[0], null);
    }

    protected Model(String tableName, String[] primaryKeys, String autoIncrement) {
        this.tableName = tableName;
        if (null != primaryKeys) {
            this.primaryKeys.addAll(Arrays.asList(primaryKeys));
        }
        this.autoIncrement = autoIncrement;
    }

    public String alias() {
        return this.alias;
    }

    public String tableName() {
        return this.tableName;
    }

    public Set<String> primaryKeys() {
        return this.primaryKeys;
    }

    public String autoIncrement() {
        return this.autoIncrement;
    }

    public void delete() {
        Bean param = (Bean)JSON.toBean((String)JSON.fromObject((Object)((Object)this)));
        ISqlDeleter deleter = SqlDaoFactory.getDao().getDeleter().table(this.tableName);
        for (String key : this.primaryKeys) {
            deleter.where(key, param.get(key));
        }
        deleter.delete();
    }

    public void save() {
        Bean param = (Bean)JSON.toBean((String)JSON.fromObject((Object)((Object)this)));
        if (param.isEmpty()) {
            return;
        }
        boolean insert = false;
        for (String key : this.primaryKeys) {
            if (key.equals(this.autoIncrement)) {
                if (param.getLong(key, 0L) >= 1L) continue;
                insert = true;
                break;
            }
            if (param.getString(key, "").length() >= 1) continue;
            insert = true;
            break;
        }
        if (insert) {
            if (null == this.autoIncrement) {
                SqlDaoFactory.getDao().getInserter().table(this.tableName).set(param).insert();
            } else {
                param.remove(this.autoIncrement);
                Bean ret = SqlDaoFactory.getDao().getInserter().table(this.tableName).set(param).insertAndGetGenerated();
                if (!ret.isEmpty()) {
                    try {
                        PropertyDescriptor[] props;
                        BeanInfo info = Introspector.getBeanInfo(((Object)((Object)this)).getClass(), Object.class);
                        for (PropertyDescriptor p : props = info.getPropertyDescriptors()) {
                            Method setterMethod;
                            if (!this.autoIncrement.equals(p.getName()) || null == (setterMethod = p.getWriteMethod())) continue;
                            Class<?> propType = p.getPropertyType();
                            Type paramType = setterMethod.getGenericParameterTypes()[0];
                            Object value = this.convert(ret.get("GENERATED_KEY"), propType, paramType);
                            setterMethod.invoke((Object)this, value);
                        }
                    }
                    catch (Exception ignore) {}
                }
            }
        } else {
            if (null != this.cache) {
                for (String key : this.cache.keySet()) {
                    String value;
                    String cacheValue = this.cache.getString(key, "");
                    if (cacheValue.equals(value = param.getString(key, ""))) {
                        param.remove(key);
                        continue;
                    }
                    this.cache.set(key, param.get(key));
                }
            }
            if (!param.isEmpty()) {
                ISqlUpdater updater = SqlDaoFactory.getDao().getUpdater().table(this.tableName);
                for (String key : this.primaryKeys) {
                    updater.where(key, param.get(key));
                }
                for (String key : this.primaryKeys) {
                    param.remove(key);
                }
                updater.set(param).update();
            }
        }
    }

    public void load() {
        Bean param = (Bean)JSON.toBean((String)JSON.fromObject((Object)((Object)this)));
        ISqlSelecter selecter = SqlDaoFactory.getDao().getSelecter().table(this.tableName);
        for (String key : this.primaryKeys) {
            selecter.where(key, param.get(key));
        }
        Bean ret = selecter.one();
        try {
            PropertyDescriptor[] props;
            BeanInfo info = Introspector.getBeanInfo(((Object)((Object)this)).getClass(), Object.class);
            for (PropertyDescriptor p : props = info.getPropertyDescriptors()) {
                Method setterMethod = p.getWriteMethod();
                if (null == setterMethod) continue;
                String key = p.getName();
                Class<?> propType = p.getPropertyType();
                Type paramType = setterMethod.getGenericParameterTypes()[0];
                Object value = this.convert(ret.get(key), propType, paramType);
                setterMethod.invoke((Object)this, value);
            }
        }
        catch (Exception ignore) {
            // empty catch block
        }
        this.cache = (Bean)JSON.toBean((String)JSON.fromObject((Object)((Object)this)));
    }

    public IModelSelecter<M> selecter() {
        return null == this.selecter ? new DefaultModelSelecter(this) : this.selecter;
    }
}

