package com.nlf.dao.setting.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import com.nlf.App;
import com.nlf.dao.setting.IDbSetting;
import com.nlf.dao.setting.IDbSettingFileFilter;
import com.nlf.dao.setting.IDbSettingProvider;

/**
 * DB配置管理器
 *
 * @author 6tail
 *
 */
public class DefaultDbSettingManager implements com.nlf.dao.setting.IDbSettingManager{

  public List<IDbSetting> listDbSettings(){
    List<IDbSetting> l = new ArrayList<IDbSetting>();
    File dir = new File(App.root,App.getProperty("nlf.dao.setting.dir"));
    if(!dir.exists()) dir.mkdirs();
    IDbSettingFileFilter filter = App.getProxy().newInstance(IDbSettingFileFilter.class.getName());
    File[] fs = dir.listFiles(filter);
    List<String> impls = App.getImplements(IDbSettingProvider.class);
    List<IDbSettingProvider> dsps = new ArrayList<IDbSettingProvider>();
    for(String klass:impls){
      IDbSettingProvider dsp = App.getProxy().newInstance(klass);
      dsps.add(dsp);
    }
    for(File f:fs){
      try{
        com.nlf.Bean o = com.nlf.serialize.json.JSON.toBean(com.nlf.util.FileUtil.readAsText(f));
        String type = o.getString("type","").toUpperCase();
        for(IDbSettingProvider dsp:dsps){
          if(dsp.support(type)){
            l.add(dsp.buildDbSetting(o));
            break;
          }
        }
      }catch(Exception e){
        throw new com.nlf.dao.exception.DaoException(App.getProperty("nlf.exception.dao.setting.format",f.getName()),e);
      }
    }
    return l;
  }
}