/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.bytecode;

import com.nlf.App;
import com.nlf.bytecode.Klass;
import com.nlf.exception.NlfException;
import com.nlf.resource.klass.ClassResource;
import com.nlf.util.IOUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ByteCodeReader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readClass(ClassResource r) throws IOException {
        String className = r.getClassName();
        if (r.isInJar()) {
            byte[] byArray;
            ZipFile zip = null;
            try {
                zip = new ZipFile(r.getRoot());
                ZipEntry entry = zip.getEntry(className.replace(".", "/") + ".class");
                InputStream in = zip.getInputStream(entry);
                byArray = IOUtil.toBytes(in);
            }
            catch (Throwable throwable) {
                IOUtil.closeQuietly(zip);
                throw throwable;
            }
            IOUtil.closeQuietly(zip);
            return byArray;
        }
        File classFile = new File(r.getRoot() + File.separator + className.replace(".", File.separator) + ".class");
        FileInputStream in = new FileInputStream(classFile);
        return IOUtil.toBytes(in);
    }

    public Set<String> readInterfaces(ClassResource r) {
        HashSet<String> interfaces = new HashSet<String>();
        try {
            ClassResource c;
            byte[] byteCodes = this.readClass(r);
            Klass klass = new Klass(byteCodes);
            r.setMethods(klass.getMethods());
            if (klass.isAbstract()) {
                r.setAbstractClass(true);
            }
            if (klass.isInterface()) {
                r.setInterfaceClass(true);
            }
            Set<String> fathers = klass.getInterfaces();
            interfaces.addAll(fathers);
            for (String father : fathers) {
                ClassResource c2 = App.CLASS.get(father);
                if (null == c2) continue;
                interfaces.addAll(this.readInterfaces(c2));
            }
            String superClass = klass.getSuperClass();
            if (!"java.lang.Object".equals(superClass) && null != (c = App.CLASS.get(superClass))) {
                interfaces.addAll(this.readInterfaces(c));
            }
        }
        catch (Throwable e) {
            throw new NlfException(r + "", e);
        }
        return interfaces;
    }
}

