/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.bytecode;

import com.nlf.bytecode.Method;
import com.nlf.bytecode.constant.AbstractConstant;
import com.nlf.bytecode.constant.ClassConstant;
import com.nlf.bytecode.constant.DefaultConstant;
import com.nlf.bytecode.constant.FieldConstant;
import com.nlf.bytecode.constant.IConstant;
import com.nlf.bytecode.constant.MethodConstant;
import com.nlf.bytecode.constant.NameAndTypeConstant;
import com.nlf.bytecode.constant.UTFConstant;
import com.nlf.util.IOUtil;
import com.nlf.util.MathUtil;
import com.nlf.util.StringUtil;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Klass {
    private byte[] byteCodes;
    private int minorVersion;
    private int majorVersion;
    private int access;
    private String superClass;
    private String name;
    private List<IConstant> constants = new ArrayList<IConstant>();
    private Set<String> interfaces = new LinkedHashSet<String>();
    private List<Method> methods = new ArrayList<Method>();

    public Klass(byte[] byteCodes) throws IOException {
        this.byteCodes = byteCodes;
        this.decode();
    }

    protected IConstant getConstant(int index) {
        return this.constants.get(index);
    }

    public Set<String> getInterfaces() {
        return this.interfaces;
    }

    public String getSuperClass() {
        return this.superClass;
    }

    public String getName() {
        return this.name;
    }

    public boolean isAbstract() {
        return Modifier.isAbstract(this.access);
    }

    public boolean isInterface() {
        return Modifier.isInterface(this.access);
    }

    public int getAccess() {
        return this.access;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public List<Method> getMethods() {
        return this.methods;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decode() throws IOException {
        ByteArrayInputStream stream = null;
        DataInputStream in = null;
        try {
            stream = new ByteArrayInputStream(this.byteCodes);
            in = new DataInputStream(stream);
            byte[] b = new byte[4];
            in.read(b);
            b = new byte[2];
            in.read(b);
            this.minorVersion = MathUtil.toInt(b);
            b = new byte[2];
            in.read(b);
            this.majorVersion = MathUtil.toInt(b);
            b = new byte[2];
            in.read(b);
            int count = MathUtil.toInt(b);
            this.constants.add(null);
            for (int i = 1; i < count; ++i) {
                byte tag = in.readByte();
                AbstractConstant c = new DefaultConstant();
                switch (tag) {
                    case 7: {
                        b = new byte[2];
                        in.read(b);
                        ClassConstant cc = new ClassConstant();
                        cc.setData(b);
                        cc.setNameIndex(MathUtil.toInt(b));
                        c = cc;
                        break;
                    }
                    case 8: {
                        b = new byte[2];
                        in.read(b);
                        break;
                    }
                    case 9: {
                        b = new byte[4];
                        in.read(b);
                        FieldConstant fc = new FieldConstant();
                        fc.setData(b);
                        fc.setClassIndex(MathUtil.toInt(MathUtil.sub(b, 0, 1)));
                        fc.setNameAndTypeIndex(MathUtil.toInt(MathUtil.sub(b, 2, 3)));
                        c = fc;
                        break;
                    }
                    case 10: {
                        b = new byte[4];
                        in.read(b);
                        MethodConstant mc = new MethodConstant();
                        mc.setData(b);
                        mc.setClassIndex(MathUtil.toInt(MathUtil.sub(b, 0, 1)));
                        mc.setNameAndTypeIndex(MathUtil.toInt(MathUtil.sub(b, 2, 3)));
                        c = mc;
                        break;
                    }
                    case 12: {
                        b = new byte[4];
                        in.read(b);
                        NameAndTypeConstant nc = new NameAndTypeConstant();
                        nc.setData(b);
                        nc.setNameIndex(MathUtil.toInt(MathUtil.sub(b, 0, 1)));
                        nc.setDescriptorIndex(MathUtil.toInt(MathUtil.sub(b, 2, 3)));
                        c = nc;
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 11: {
                        b = new byte[4];
                        in.read(b);
                        c.setData(b);
                        break;
                    }
                    case 1: {
                        b = new byte[2];
                        in.read(b);
                        int length = MathUtil.toInt(b);
                        b = new byte[length];
                        in.read(b);
                        UTFConstant uc = new UTFConstant();
                        uc.setData(b);
                        uc.setContent(new String(b, "utf-8"));
                        c = uc;
                        break;
                    }
                    case 5: 
                    case 6: {
                        b = new byte[8];
                        in.read(b);
                        c.setData(b);
                    }
                }
                c.setIndex(i);
                c.setType(tag);
                this.constants.add(c);
                if (5 != c.getType() && 6 != c.getType()) continue;
                this.constants.add(null);
                ++i;
            }
            b = new byte[2];
            in.read(b);
            this.access = MathUtil.toInt(b);
            b = new byte[2];
            in.read(b);
            this.name = this.getConstant(this.getConstant(MathUtil.toInt(b)).toClassConstant().getNameIndex()).toUTFConstant().getContent();
            this.name = this.name.replace("/", ".");
            b = new byte[2];
            in.read(b);
            this.superClass = this.getConstant(this.getConstant(MathUtil.toInt(b)).toClassConstant().getNameIndex()).toUTFConstant().getContent();
            this.superClass = this.superClass.replace("/", ".");
            b = new byte[2];
            in.read(b);
            int interfaceCount = MathUtil.toInt(b);
            for (int i = 0; i < interfaceCount; ++i) {
                b = new byte[2];
                in.read(b);
                String interfaceClass = this.getConstant(this.getConstant(MathUtil.toInt(b)).toClassConstant().getNameIndex()).toUTFConstant().getContent();
                interfaceClass = interfaceClass.replace("/", ".");
                this.interfaces.add(interfaceClass);
            }
            in.read(b);
            int fieldCount = MathUtil.toInt(b);
            for (int i = 0; i < fieldCount; ++i) {
                b = new byte[2];
                in.skip(6L);
                in.read(b);
                int attributeCount = MathUtil.toInt(b);
                for (int j = 0; j < attributeCount; ++j) {
                    in.skip(2L);
                    b = new byte[4];
                    in.read(b);
                    int length = MathUtil.toInt(b);
                    in.skip(length);
                }
            }
            b = new byte[2];
            in.read(b);
            int methodCount = MathUtil.toInt(b);
            for (int i = 0; i < methodCount; ++i) {
                Method f = new Method(this);
                b = new byte[2];
                in.read(b);
                f.setAccess(MathUtil.toInt(b));
                in.read(b);
                f.setNameIndex(MathUtil.toInt(b));
                in.read(b);
                f.setDescriptorIndex(MathUtil.toInt(b));
                in.read(b);
                int attributeCount = MathUtil.toInt(b);
                String methodName = f.getName();
                block24: for (int j = 0; j < attributeCount; ++j) {
                    b = new byte[2];
                    in.read(b);
                    String attrName = this.getConstant(MathUtil.toInt(b)).toUTFConstant().getContent();
                    b = new byte[4];
                    in.read(b);
                    int length = MathUtil.toInt(b);
                    b = new byte[length];
                    in.read(b);
                    if ("<init>".equals(methodName) || "<clinit>".equals(methodName) || methodName.startsWith("$SWITCH_TABLE$") || !"Code".equals(attrName)) continue;
                    length = MathUtil.toInt(MathUtil.sub(b, 4, 7));
                    b = MathUtil.sub(b, 8, 8 + length - 1);
                    for (int k = length - 1; k > -1; --k) {
                        int op = b[k] & 0xFF;
                        if (172 == op) {
                            f.setRetMaybe("I");
                            continue block24;
                        }
                        if (173 == op) {
                            f.setRetMaybe("J");
                            continue block24;
                        }
                        if (174 == op) {
                            f.setRetMaybe("F");
                            continue block24;
                        }
                        if (175 == op) {
                            f.setRetMaybe("D");
                            continue block24;
                        }
                        if (176 == op) {
                            for (int x = k - 1; x > -1; --x) {
                                int p = b[x] & 0xFF;
                                try {
                                    IConstant c = this.getConstant(p);
                                    switch (c.getType()) {
                                        case 7: {
                                            String retType = "L" + this.getConstant(c.toClassConstant().getNameIndex()).toUTFConstant().getContent();
                                            f.setRetMaybe(retType);
                                            continue block24;
                                        }
                                        case 9: {
                                            String retType = this.getConstant(this.getConstant(c.toFieldConstant().getNameAndTypeIndex()).toNameAndTypeConstant().getDescriptorIndex()).toUTFConstant().getContent();
                                            if (retType.contains(";")) {
                                                retType = retType.substring(0, retType.indexOf(";"));
                                            }
                                            f.setRetMaybe(retType);
                                            continue block24;
                                        }
                                        case 10: {
                                            String retType = this.getConstant(this.getConstant(c.toMethodConstant().getNameAndTypeIndex()).toNameAndTypeConstant().getDescriptorIndex()).toUTFConstant().getContent();
                                            if (retType.contains(")")) {
                                                retType = retType.substring(retType.lastIndexOf(")") + 1);
                                            }
                                            if (retType.contains(";")) {
                                                retType = retType.substring(0, retType.indexOf(";"));
                                            }
                                            f.setRetMaybe(retType);
                                            continue block24;
                                        }
                                    }
                                    continue;
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            continue block24;
                        }
                        if (177 != op) continue;
                        f.setRetMaybe("V");
                        continue block24;
                    }
                }
                this.methods.add(f);
            }
        }
        catch (Throwable throwable) {
            IOUtil.closeQuietly(in);
            IOUtil.closeQuietly(stream);
            throw throwable;
        }
        IOUtil.closeQuietly(in);
        IOUtil.closeQuietly(stream);
    }

    public String toString() {
        ArrayList<String> l = new ArrayList<String>();
        l.add(this.access + "");
        l.add(this.isAbstract() ? "abstract" : "");
        l.add(this.isInterface() ? "interface" : "class");
        l.add(this.name);
        l.add("extends");
        l.add(this.superClass);
        l.add("implements");
        l.add(StringUtil.join(this.interfaces, ","));
        return StringUtil.join(l, " ");
    }
}

