/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.core.impl;

import com.nlf.App;
import com.nlf.bytecode.ByteCodeReader;
import com.nlf.core.AbstractScanner;
import com.nlf.core.IScanner;
import com.nlf.exception.NlfException;
import com.nlf.resource.ResourceFileFilter;
import com.nlf.resource.i18n.I18nResource;
import com.nlf.resource.i18n.comparator.I18nComparator;
import com.nlf.resource.klass.ClassResource;
import com.nlf.resource.klass.comparator.ClassComparator;
import com.nlf.resource.klass.filter.JarFileFilter;
import com.nlf.util.IOUtil;
import com.nlf.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultScanner
extends AbstractScanner {
    public static final String CHARSET = "utf-8";
    public static final String SUF_JAR = ".jar";
    public static final String SUF_CLS = ".class";
    public static final String SUF_PPT = ".properties";
    protected JarFileFilter jarFilter = new JarFileFilter();
    protected ResourceFileFilter resourceFilter = new ResourceFileFilter();
    protected ClassComparator classComparator = new ClassComparator();
    protected I18nComparator i18nComparator = new I18nComparator();
    protected ByteCodeReader byteCodeReader = new ByteCodeReader();
    protected Set<String> jars = new HashSet<String>();
    protected Set<String> classes = new HashSet<String>();

    public DefaultScanner() {
        this.ignoreJarByManifestAttribute("Bundle-Vendor", "*Apache*", "*Eclipse*", "%bundleProvider", "%Bundle-Vendor*");
        this.ignoreJarByManifestAttribute("Created-By", "*Alibaba*", "*Apache*", "*Apple*", "*IBM*", "*Oracle*", "*Signtool*", "*Sun Microsystems*", "*JetBrains*");
        this.ignoreJarByManifestAttribute("Implementation-Vendor", "*Alibaba*", "*Apache*", "*MetaStuff*", "*MySQL*", "*Oracle*", "*Sun Microsystems*");
    }

    protected Set<String> filterJarPath(Collection<String> paths) {
        HashSet<String> l = new HashSet<String>();
        for (String p : paths) {
            l.addAll(this.filterJarPath(p));
        }
        return l;
    }

    protected Set<String> filterJarPath(String ... paths) {
        HashSet<String> l = new HashSet<String>();
        for (String p : paths) {
            File f;
            if (null == p || (p = p.trim()).length() < 1 || !(f = new File(p)).exists()) continue;
            if (f.isDirectory()) {
                File[] fs;
                for (File file : fs = f.listFiles(this.jarFilter)) {
                    l.add(file.getAbsolutePath());
                }
                continue;
            }
            if (!f.getName().endsWith(SUF_JAR)) continue;
            l.add(f.getAbsolutePath());
        }
        return l;
    }

    protected Set<String> findJarsFromClassPath() {
        return this.filterJarPath(System.getProperty("java.class.path").split(File.pathSeparator));
    }

    protected String findCallerPath() throws ClassNotFoundException, UnsupportedEncodingException {
        if (null == App.caller) {
            if (null == this.caller) {
                Class<?> callerClass;
                URL url;
                StackTraceElement[] sts = Thread.currentThread().getStackTrace();
                String callerClassName = null;
                boolean isFrameClass = false;
                for (StackTraceElement t : sts) {
                    String className = t.getClassName();
                    if (className.startsWith(App.PACKAGE)) {
                        isFrameClass = true;
                        continue;
                    }
                    if (!isFrameClass) continue;
                    callerClassName = className;
                    break;
                }
                if (null == (url = (callerClass = Class.forName(callerClassName)).getClassLoader().getResource("/"))) {
                    url = callerClass.getProtectionDomain().getCodeSource().getLocation();
                }
                App.caller = new File(URLDecoder.decode(url.getPath(), CHARSET)).getAbsolutePath();
            } else {
                App.caller = this.caller;
            }
        }
        return App.caller;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<String> findJarsFromCallerClassPath() throws IOException {
        HashSet<String> classPaths = new HashSet<String>();
        String callerPath = App.caller;
        if (callerPath.endsWith(SUF_JAR)) {
            JarFile jar;
            block3: {
                jar = null;
                try {
                    Attributes attrs;
                    String classPath;
                    jar = new JarFile(callerPath);
                    Manifest mf = jar.getManifest();
                    if (null == mf || null == (classPath = (attrs = mf.getMainAttributes()).getValue("Class-Path"))) break block3;
                    String[] cps = classPath.split(" ");
                    classPaths.addAll(this.filterJarPath(cps));
                }
                catch (Throwable throwable) {
                    IOUtil.closeQuietly(jar);
                    throw throwable;
                }
            }
            IOUtil.closeQuietly(jar);
        }
        return classPaths;
    }

    protected Set<String> convertToAbsolutePaths(Set<String> paths) {
        HashSet<String> l = new HashSet<String>();
        for (String p : paths) {
            File f = new File(App.root, p);
            if (!f.exists()) continue;
            l.add(f.getAbsolutePath());
        }
        return l;
    }

    @Override
    public IScanner start() {
        try {
            this.findCallerPath();
            this.findAppRoot();
            System.out.println("App.caller         = " + App.caller);
            System.out.println("App.root           = " + App.root);
            if (App.caller.endsWith(SUF_JAR)) {
                this.jars.add(App.caller);
            } else {
                this.classes.add(App.caller);
            }
            if (App.root.endsWith(SUF_JAR)) {
                this.jars.add(App.root);
            } else {
                this.classes.add(App.root);
            }
            this.jars.addAll(this.findJarsFromClassPath());
            this.jars.addAll(this.findJarsFromCallerClassPath());
            this.jars.addAll(this.filterJarPath(this.addedAbsolutePaths));
            this.jars.addAll(this.filterJarPath(this.convertToAbsolutePaths(this.addedRelativePaths)));
            this.scan();
            this.buildInterface();
            this.buildImpls();
            this.buildI18n();
        }
        catch (Exception e) {
            throw new NlfException(e);
        }
        return this;
    }

    protected void buildI18n() {
        if (App.I18N.size() > 1) {
            ArrayList<String> l = new ArrayList<String>(App.I18N.size());
            l.addAll(App.I18N);
            Collections.sort(l, this.i18nComparator);
            App.I18N.clear();
            App.I18N.addAll(l);
        }
    }

    protected void buildImpls() {
        App.INTERFACE_IMPLEMENTS.clear();
        for (ClassResource classResource : App.CLASS.values()) {
            for (String it : classResource.getInterfaces()) {
                if (!App.CLASS.containsKey(it)) continue;
                List<String> l = App.INTERFACE_IMPLEMENTS.get(it);
                if (null == l) {
                    l = new ArrayList<String>();
                    App.INTERFACE_IMPLEMENTS.put(it, l);
                }
                if (classResource.isAbstractClass()) continue;
                l.add(classResource.getClassName());
            }
        }
        for (Map.Entry entry : App.INTERFACE_IMPLEMENTS.entrySet()) {
            List l = (List)entry.getValue();
            if (l.size() <= 1) continue;
            Collections.sort(l, this.classComparator);
        }
    }

    protected void buildInterface() {
        for (ClassResource ci : App.CLASS.values()) {
            ci.setInterfaces(this.byteCodeReader.readInterfaces(ci));
        }
    }

    protected void scanClasses(File file, String root) {
        if (file.isDirectory()) {
            File[] fs;
            for (File f : fs = file.listFiles(this.resourceFilter)) {
                this.scanClasses(f, root);
            }
            return;
        }
        String fileName = file.getAbsolutePath().replace(root, "");
        if (fileName.startsWith(File.separator)) {
            fileName = fileName.substring(File.separator.length());
        }
        if (fileName.endsWith(SUF_CLS)) {
            String name = fileName.substring(0, fileName.lastIndexOf(".")).replace(File.separator, ".");
            ClassResource cr = new ClassResource();
            cr.setClassName(name);
            cr.setRoot(root);
            cr.setInJar(false);
            cr.setFileName(file.getName());
            App.CLASS.put(name, cr);
        } else if (fileName.endsWith(SUF_PPT)) {
            String name = fileName.substring(0, fileName.lastIndexOf(".")).replace(File.separator, ".");
            for (Locale locale : Locale.getAvailableLocales()) {
                String tag = "_" + locale.getLanguage();
                if (!name.endsWith(tag)) continue;
                name = name.substring(0, name.lastIndexOf(tag));
                break;
            }
            I18nResource ir = new I18nResource();
            ir.setRoot(root);
            ir.setInJar(false);
            ir.setName(name);
            ir.setFileName(fileName);
            App.I18N_RESOURCE.add(ir);
            App.I18N.add(name);
        }
    }

    protected boolean matchAttributes(Attributes attrs) {
        for (Map.Entry entry : this.ignoredManifestAttributes.entrySet()) {
            for (String value : (Set)entry.getValue()) {
                String attrValue = attrs.getValue((String)entry.getKey());
                if (!StringUtil.matches(attrValue, value)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scanJar(File jarFile) throws IOException {
        JarFile jar;
        String root;
        block11: {
            Manifest mf;
            block12: {
                root = jarFile.getAbsolutePath();
                for (String p : this.ignoredPaths) {
                    if (!StringUtil.matches(root, p)) continue;
                    return;
                }
                jar = null;
                jar = new JarFile(jarFile);
                mf = jar.getManifest();
                if (null == mf) break block11;
                if (!this.matchAttributes(mf.getMainAttributes())) break block12;
                IOUtil.closeQuietly(jar);
                return;
            }
            try {
                for (Attributes attrs : mf.getEntries().values()) {
                    if (!this.matchAttributes(attrs)) break block13;
                }
            }
            catch (Throwable throwable) {
                IOUtil.closeQuietly(jar);
                throw throwable;
            }
            {
                block13: {
                    IOUtil.closeQuietly(jar);
                    return;
                }
                continue;
            }
        }
        IOUtil.closeQuietly(jar);
        System.out.println("[v] " + root);
        ZipFile zip = null;
        try {
            zip = new ZipFile(jarFile);
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                String name;
                ZipEntry entry = entries.nextElement();
                String fileName = entry.getName();
                if (fileName.endsWith(SUF_CLS)) {
                    name = fileName.substring(0, fileName.lastIndexOf(".")).replace("/", ".");
                    Locale[] ci = new ClassResource();
                    ci.setClassName(name);
                    ci.setRoot(root);
                    ci.setInJar(true);
                    ci.setFileName(entry.getName());
                    App.CLASS.put(name, (ClassResource)ci);
                    continue;
                }
                if (!fileName.endsWith(SUF_PPT)) continue;
                name = fileName.substring(0, fileName.lastIndexOf(".")).replace("/", ".");
                for (Locale locale : Locale.getAvailableLocales()) {
                    String tag = "_" + locale;
                    if (!name.endsWith(tag)) continue;
                    name = name.substring(0, name.lastIndexOf(tag));
                    break;
                }
                I18nResource ir = new I18nResource();
                ir.setRoot(root);
                ir.setInJar(true);
                ir.setName(name);
                ir.setFileName(fileName);
                App.I18N_RESOURCE.add(ir);
                App.I18N.add(name);
            }
        }
        catch (Throwable throwable) {
            IOUtil.closeQuietly(zip);
            throw throwable;
        }
        IOUtil.closeQuietly(zip);
    }

    protected void scan() throws IOException {
        App.I18N_RESOURCE.clear();
        for (String p : this.classes) {
            System.out.println("[v] " + p);
            this.scanClasses(new File(p), p);
        }
        for (String p : this.jars) {
            this.scanJar(new File(p));
        }
    }

    protected String findAppRoot() {
        if (null == App.root) {
            String callerPath = App.caller;
            App.root = callerPath.endsWith(SUF_JAR) ? new File(callerPath).getParentFile().getAbsolutePath() : callerPath;
        }
        return App.root;
    }
}

