/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.dao.connection;

import com.nlf.App;
import com.nlf.dao.connection.IConnection;
import com.nlf.dao.connection.IConnectionProvider;
import com.nlf.dao.exception.DaoException;
import com.nlf.dao.setting.DbSettingFactory;
import com.nlf.dao.setting.IDbSetting;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ConnectionFactory {
    protected static final Map<String, IConnectionProvider> pool = new HashMap<String, IConnectionProvider>();

    protected ConnectionFactory() {
    }

    public static IConnection getConnection(String alias) {
        IConnection connection;
        HashMap<String, IConnection> connections = (HashMap<String, IConnection>)App.get("NLF_CONNECTION");
        if (null == connections) {
            connections = new HashMap<String, IConnection>();
            App.set("NLF_CONNECTION", connections);
        }
        if (null != (connection = (IConnection)connections.get(alias)) && !connection.isClosed()) {
            return connection;
        }
        IDbSetting setting = DbSettingFactory.getSetting(alias);
        String type = setting.getType();
        String key = alias;
        if (!pool.containsKey(key)) {
            List<String> impls = App.getImplements(IConnectionProvider.class);
            for (String impl : impls) {
                IConnectionProvider p = (IConnectionProvider)App.getProxy().newInstance(impl);
                if (!p.support(type)) continue;
                pool.put(key, p);
                p.setDbSetting(setting);
                IConnection conn = p.getConnection();
                connections.put(alias, conn);
                return conn;
            }
            pool.put(key, null);
        } else {
            IConnectionProvider p = pool.get(key);
            if (null != p) {
                IConnection conn = p.getConnection();
                connections.put(alias, conn);
                return conn;
            }
        }
        throw new DaoException(App.getProperty("nlf.exception.dao.connection.provider.not_found", type));
    }

    public static IConnection getConnection() {
        return ConnectionFactory.getConnection(DbSettingFactory.getDefaultSetting().getAlias());
    }
}

