/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.dao.paging;

import com.nlf.App;
import com.nlf.Bean;
import com.nlf.dao.paging.IPagingRender;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageData
implements List<Bean>,
Serializable {
    private static final long serialVersionUID = 1L;
    private String id;
    private int pageSize;
    private int recordCount;
    private int pageNumber;
    private List<Bean> data = new ArrayList<Bean>();

    public PageData() {
    }

    public PageData(List<Bean> data, int pageSize, int pageNumber, int recordCount) {
        this.setData(data);
        this.setPageSize(pageSize);
        this.setPageNumber(pageNumber);
        this.setRecordCount(recordCount);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize < 1 ? 1 : pageSize;
    }

    public int getRecordCount() {
        return this.recordCount;
    }

    public void setRecordCount(int recordCount) {
        this.recordCount = recordCount < 0 ? 0 : recordCount;
    }

    public int getPageCount() {
        return this.recordCount < 1 || this.pageSize < 1 ? 1 : (int)Math.ceil((double)this.recordCount * 1.0 / (double)this.pageSize);
    }

    public int getPreviousPageNumber() {
        return this.pageNumber - 1 < 1 ? 1 : this.pageNumber - 1;
    }

    public int getNextPageNumber() {
        return this.pageNumber + 1 > this.getPageCount() ? this.getPageCount() : this.pageNumber + 1;
    }

    public int getFirstPageNumber() {
        return 1;
    }

    public int getLastPageNumber() {
        return this.getPageCount();
    }

    public int[] getNearPageNumbers(int count) {
        int pageCount = this.getPageCount();
        int start = this.pageNumber - count;
        int end = this.pageNumber + count;
        end = end < 1 ? 1 : end;
        end = end > pageCount ? this.pageNumber : end;
        start = start < 1 ? 1 : start;
        int[] m = new int[end + 1 - start];
        for (int i = 0; i < m.length; ++i) {
            m[i] = start + i;
        }
        return m;
    }

    public int getSize() {
        return null == this.data ? 0 : this.data.size();
    }

    public int getPageNumber() {
        return this.pageNumber;
    }

    public void setPageNumber(int pageNumber) {
        this.pageNumber = pageNumber < 1 ? 1 : pageNumber;
    }

    public List<Bean> getData() {
        return this.data;
    }

    public void setData(List<Bean> data) {
        this.data = data;
    }

    @Override
    public Bean get(int index) {
        return this.data.get(index);
    }

    @Override
    public boolean add(Bean o) {
        return this.data.add(o);
    }

    @Override
    public void add(int index, Bean element) {
        this.data.add(index, element);
    }

    @Override
    public boolean addAll(Collection<? extends Bean> c) {
        return this.data.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends Bean> c) {
        return this.data.addAll(index, c);
    }

    @Override
    public void clear() {
        this.data.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.data.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.data.containsAll(c);
    }

    @Override
    public int indexOf(Object o) {
        return this.data.indexOf(o);
    }

    @Override
    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    @Override
    public Iterator<Bean> iterator() {
        return this.data.iterator();
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.data.lastIndexOf(o);
    }

    @Override
    public ListIterator<Bean> listIterator() {
        return this.data.listIterator();
    }

    @Override
    public ListIterator<Bean> listIterator(int index) {
        return this.data.listIterator(index);
    }

    @Override
    public boolean remove(Object o) {
        return this.data.remove(o);
    }

    @Override
    public Bean remove(int index) {
        return this.data.remove(index);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.data.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.data.retainAll(c);
    }

    @Override
    public Bean set(int index, Bean element) {
        return this.data.set(index, element);
    }

    @Override
    public int size() {
        return this.data.size();
    }

    @Override
    public List<Bean> subList(int fromIndex, int toIndex) {
        return this.data.subList(fromIndex, toIndex);
    }

    @Override
    public Object[] toArray() {
        return this.data.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.data.toArray(a);
    }

    public String toString() {
        IPagingRender render = (IPagingRender)App.getProxy().newInstance(IPagingRender.class.getName());
        return render.render(this);
    }
}

