/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.dao.setting.impl;

import com.nlf.App;
import com.nlf.Bean;
import com.nlf.dao.exception.DaoException;
import com.nlf.dao.setting.IDbSetting;
import com.nlf.dao.setting.IDbSettingFileFilter;
import com.nlf.dao.setting.IDbSettingManager;
import com.nlf.dao.setting.IDbSettingProvider;
import com.nlf.serialize.json.JSON;
import com.nlf.util.FileUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDbSettingManager
implements IDbSettingManager {
    @Override
    public List<IDbSetting> listDbSettings() {
        ArrayList<IDbSetting> l = new ArrayList<IDbSetting>();
        File dir = new File(App.root, App.getProperty("nlf.dao.setting.dir", new Object[0]));
        if (!dir.exists()) {
            dir.mkdirs();
        }
        IDbSettingFileFilter filter = (IDbSettingFileFilter)App.getProxy().newInstance(IDbSettingFileFilter.class.getName());
        File[] fs = dir.listFiles(filter);
        List<String> impls = App.getImplements(IDbSettingProvider.class);
        ArrayList<IDbSettingProvider> dsps = new ArrayList<IDbSettingProvider>();
        for (String klass : impls) {
            IDbSettingProvider dsp = (IDbSettingProvider)App.getProxy().newInstance(klass);
            dsps.add(dsp);
        }
        block3: for (File f : fs) {
            try {
                Bean o = (Bean)JSON.toBean(FileUtil.readAsText(f));
                String type = o.getString("type", "").toUpperCase();
                for (IDbSettingProvider dsp : dsps) {
                    if (!dsp.support(type)) continue;
                    l.add(dsp.buildDbSetting(o));
                    continue block3;
                }
            }
            catch (Exception e) {
                throw new DaoException(App.getProperty("nlf.exception.dao.setting.format", f.getName()), e);
            }
        }
        return l;
    }
}

