/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.extend.dao.sql;

import com.nlf.App;
import com.nlf.dao.exception.DaoException;
import com.nlf.dao.transaction.AbstractTransaction;
import com.nlf.extend.dao.sql.SqlConnection;
import com.nlf.util.IOUtil;
import java.sql.SQLException;

public class SqlTransaction
extends AbstractTransaction {
    public void commit() {
        try {
            SqlConnection conn = (SqlConnection)this.connection;
            conn.getConnection().commit();
            conn.setInBatch(false);
        }
        catch (SQLException e) {
            throw new DaoException(e);
        }
    }

    public void rollback() {
        try {
            SqlConnection conn = (SqlConnection)this.connection;
            conn.getConnection().rollback();
            conn.setInBatch(false);
        }
        catch (SQLException e) {
            throw new DaoException(e);
        }
    }

    public void startBatch() {
        SqlConnection conn = (SqlConnection)this.connection;
        if (!conn.supportsBatchUpdates()) {
            throw new DaoException(App.getProperty("nlf.exception.dao.batch_not_support", conn.getDbSetting().getAlias()));
        }
        conn.setStatement(null);
        conn.setInBatch(true);
    }

    public int[] executeBatch() {
        SqlConnection conn = (SqlConnection)this.connection;
        if (!conn.isInBatch()) {
            throw new DaoException(App.getProperty("nlf.exception.dao.batch_not_start", new Object[0]));
        }
        try {
            int[] n = conn.getStatement().executeBatch();
            conn.setInBatch(false);
            int[] nArray = n;
            return nArray;
        }
        catch (SQLException e) {
            throw new DaoException(e);
        }
        finally {
            IOUtil.closeQuietly(conn.getStatement());
        }
    }
}

