/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.extend.dao.sql.dbType.mysql;

import com.nlf.Bean;
import com.nlf.dao.exception.DaoException;
import com.nlf.dao.paging.PageData;
import com.nlf.extend.dao.sql.SqlConnection;
import com.nlf.extend.dao.sql.dbType.common.ASqlTemplate;
import com.nlf.log.Logger;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MysqlTemplate
extends ASqlTemplate {
    @Override
    public boolean support(String dbType) {
        return "mysql".equalsIgnoreCase(dbType);
    }

    @Override
    public List<Bean> top(int count) {
        List<Bean> list;
        this.params.clear();
        String sql = this.buildSql();
        sql = sql + " LIMIT 0," + count;
        this.sql = sql = this.buildParams(sql, this.param);
        Logger.getLog().debug(this.buildLog());
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = ((SqlConnection)this.connection).getConnection().prepareStatement(sql);
            this.bindParams(stmt);
            rs = stmt.executeQuery();
            list = this.toBeans(rs);
        }
        catch (SQLException e) {
            try {
                throw new DaoException(e);
            }
            catch (Throwable throwable) {
                this.finalize(stmt, rs);
                throw throwable;
            }
        }
        this.finalize(stmt, rs);
        return list;
    }

    @Override
    public PageData page(int pageNumber, int pageSize) {
        PageData d = new PageData();
        d.setPageSize(pageSize);
        d.setPageNumber(pageNumber);
        d.setRecordCount(this.count());
        if (d.getPageNumber() > d.getPageCount()) {
            return d;
        }
        this.params.clear();
        String sql = this.buildSql();
        sql = "SELECT * FROM (" + sql + ") NLFTABLE_ LIMIT " + (d.getPageNumber() - 1) * d.getPageSize() + "," + d.getPageSize();
        this.sql = sql = this.buildParams(sql, this.param);
        Logger.getLog().debug(this.buildLog());
        PreparedStatement stmt = null;
        ResultSet rs = null;
        List<Bean> l = null;
        try {
            stmt = ((SqlConnection)this.connection).getConnection().prepareStatement(sql);
            this.bindParams(stmt);
            rs = stmt.executeQuery();
            l = this.toBeans(rs);
        }
        catch (SQLException e) {
            try {
                throw new DaoException(e);
            }
            catch (Throwable throwable) {
                this.finalize(stmt, rs);
                throw throwable;
            }
        }
        this.finalize(stmt, rs);
        d.setData(l);
        return d;
    }
}

