/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.extend.web.impl;

import com.nlf.App;
import com.nlf.Bean;
import com.nlf.core.Client;
import com.nlf.core.IFileUploader;
import com.nlf.core.ISession;
import com.nlf.core.UploadFile;
import com.nlf.extend.serialize.obj.OBJ;
import com.nlf.extend.web.AbstractWebRequest;
import com.nlf.extend.web.IWebFileUploader;
import com.nlf.extend.web.impl.DefaultWebSession;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultWebRequest
extends AbstractWebRequest {
    public static final String[] PROXY_HEADER = new String[]{"X-Real-IP", "X-Forwarded-For", "Proxy-Client-IP", "WL-Proxy-Client-IP", "HTTP_CLIENT_IP", "HTTP_X_FORWARDED_FOR"};

    protected String getIP() {
        String r = this.servletRequest.getRemoteAddr();
        Enumeration em = this.servletRequest.getHeaderNames();
        block0: while (em.hasMoreElements()) {
            String k = (String)em.nextElement();
            for (String s : PROXY_HEADER) {
                String p;
                if (!s.equalsIgnoreCase(k) || null == (p = this.servletRequest.getHeader(k)) || p.length() <= 0 || "unknown".equalsIgnoreCase(p)) continue;
                r = p;
                break block0;
            }
        }
        if (null != r) {
            if (r.indexOf(",") > -1) {
                String[] rs = r.split(",");
                for (String s : rs) {
                    if (s.length() <= 0 || "unknown".equalsIgnoreCase(s)) continue;
                    r = s;
                    break;
                }
            }
            if ("0:0:0:0:0:0:0:1".equals(r)) {
                r = "127.0.0.1";
            }
        }
        if (null == r) {
            r = "";
        }
        return r;
    }

    @Override
    public void init() {
        try {
            this.initParam();
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        String contentType = this.servletRequest.getContentType();
        if (null != contentType && contentType.contains("multipart/form-data")) {
            IFileUploader uploader = (IFileUploader)App.getProxy().newInstance(IWebFileUploader.class.getName());
            List<UploadFile> files = uploader.getFiles();
            this.param.set("uploadFiles", files);
        }
        this.initPaging();
    }

    protected void initParam() throws UnsupportedEncodingException {
        String headAjax = this.servletRequest.getHeader("x-requested-with");
        String reqMethod = this.servletRequest.getMethod();
        Enumeration en = this.servletRequest.getParameterNames();
        while (en.hasMoreElements()) {
            int i;
            int j;
            String key = (String)en.nextElement();
            String value = this.servletRequest.getParameter(key);
            String[] values = this.servletRequest.getParameterValues(key);
            if (null == value) {
                value = "";
            }
            if (null == values) {
                values = new String[]{};
            }
            if (null == headAjax) {
                if ("GET".equalsIgnoreCase(reqMethod)) {
                    value = new String(value.getBytes("ISO-8859-1"), "utf-8");
                    j = values.length;
                    for (i = 0; i < j; ++i) {
                        values[i] = new String(values[i].getBytes("ISO-8859-1"), "utf-8");
                    }
                }
            } else {
                value = URLDecoder.decode(value, "utf-8");
                j = values.length;
                for (i = 0; i < j; ++i) {
                    values[i] = URLDecoder.decode(values[i], "utf-8");
                }
            }
            this.param.set(key, value);
            if (values.length <= 1) continue;
            this.param.set(key, values);
        }
    }

    protected void initPaging() {
        String s = this.param.getString("pagingParam");
        Bean pageParam = null;
        try {
            pageParam = (Bean)OBJ.toBean(s);
        }
        catch (Exception e) {
            pageParam = new Bean();
        }
        for (String key : this.param.keySet()) {
            if ("pagingParam".equals(key) || "uploadFiles".equals(key)) continue;
            pageParam.set(key, this.param.get(key));
        }
        String uri = this.servletRequest.getServletPath();
        pageParam.set("pagingUri", uri);
        int pageNumber = this.param.getInt("pageNumber", this.pageNumber);
        int pageSize = this.param.getInt("pageSize", this.pageSize);
        pageParam.set("pageNumber", pageNumber);
        pageParam.set("pageSize", pageSize);
        this.setPageNumber(pageNumber);
        this.setPageSize(pageSize);
        this.param.set("pagingParam", OBJ.fromObject(pageParam));
    }

    @Override
    public Client getClient() {
        if (null == this.client) {
            this.client = new Client();
            this.client.setIp(this.getIP());
            this.client.setLocale(this.servletRequest.getLocale());
        }
        return this.client;
    }

    @Override
    public ISession getSession() {
        if (null == this.session) {
            boolean autoCreate = Boolean.parseBoolean(App.getProperty("nlf.session.auto_create", new Object[0]));
            DefaultWebSession webSession = new DefaultWebSession();
            webSession.setSession(this.servletRequest.getSession(autoCreate));
            this.session = webSession;
        }
        return this.session;
    }

    @Override
    public List<UploadFile> getFiles() {
        List files = (List)this.param.get("uploadFiles");
        return null == files ? new ArrayList(0) : files;
    }
}

