/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.log;

import com.nlf.App;
import com.nlf.log.ILog;
import com.nlf.log.ILogAdapter;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Logger {
    public static final String KLASS = Logger.class.getName();
    private static ILogAdapter adapter;

    private Logger() {
    }

    private static StackTraceElement findStackTrace() {
        StackTraceElement[] sts;
        int index = 0;
        for (StackTraceElement st : sts = Thread.currentThread().getStackTrace()) {
            if (KLASS.equals(st.getClassName())) {
                index += 2;
                break;
            }
            ++index;
        }
        return sts[index];
    }

    public static ILog getLog() {
        return adapter.getLog(Logger.findStackTrace().getClassName());
    }

    public static ILog getLog(String name) {
        return adapter.getLog(name);
    }

    public static ILog getLog(Class<?> klass) {
        return adapter.getLog(klass.getName());
    }

    static {
        List<String> l = App.getImplements(ILogAdapter.class);
        for (String c : l) {
            try {
                ILogAdapter a = (ILogAdapter)App.getProxy().newInstance(c);
                if (!a.isSupported()) continue;
                adapter = a;
                break;
            }
            catch (Exception exception) {
            }
        }
    }
}

