/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.util;

import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.net.NetworkInterface;
import java.nio.ByteBuffer;
import java.util.Enumeration;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;

public class IDUtil
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final int _time = (int)(System.currentTimeMillis() / 1000L);
    private final int _machine = _genmachine;
    private final int _inc = _nextInc.getAndIncrement();
    private static AtomicInteger _nextInc;
    private static final int _genmachine;

    public static String next() {
        return new IDUtil().toHexString();
    }

    private IDUtil() {
    }

    private String toHexString() {
        StringBuilder s = new StringBuilder(24);
        for (byte b : this.toByteArray()) {
            s.append(String.format("%02x", b & 0xFF));
        }
        return s + "";
    }

    private byte[] toByteArray() {
        byte[] b = new byte[12];
        ByteBuffer bb = ByteBuffer.wrap(b);
        bb.putInt(this._time);
        bb.putInt(this._machine);
        bb.putInt(this._inc);
        return b;
    }

    static {
        int machinePiece;
        _nextInc = new AtomicInteger(new Random().nextInt());
        try {
            StringBuilder s = new StringBuilder();
            Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
            while (e.hasMoreElements()) {
                s.append(e.nextElement().toString());
            }
            machinePiece = s.toString().hashCode() << 16;
        }
        catch (Throwable e) {
            machinePiece = new Random().nextInt() << 16;
        }
        int processId = new Random().nextInt();
        try {
            processId = ManagementFactory.getRuntimeMXBean().getName().hashCode();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        ClassLoader loader = IDUtil.class.getClassLoader();
        int loaderId = loader != null ? System.identityHashCode(loader) : 0;
        StringBuilder s = new StringBuilder();
        s.append(Integer.toHexString(processId));
        s.append(Integer.toHexString(loaderId));
        int processPiece = s.toString().hashCode() & 0xFFFF;
        _genmachine = machinePiece | processPiece;
    }
}

