/*
 * Decompiled with CFR 0.152.
 */
package com.nlf;

import com.nlf.core.IProxy;
import com.nlf.core.IRequest;
import com.nlf.core.IResponse;
import com.nlf.core.ScannerFactory;
import com.nlf.core.Var;
import com.nlf.core.impl.DefaultProxy;
import com.nlf.resource.i18n.I18nResource;
import com.nlf.resource.klass.ClassResource;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class App {
    public static String root;
    public static String caller;
    public static String frame;
    public static final Set<String> DIRECTORIES;
    public static final Set<String> I18N;
    public static final String PACKAGE;
    public static final List<I18nResource> I18N_RESOURCE;
    public static final Map<String, ClassResource> CLASS;
    public static final Map<String, List<String>> INTERFACE_IMPLEMENTS;
    protected static final Map<String, Map<Locale, String>> I18N_CACHE;
    private static volatile IProxy proxy;
    private static final ThreadLocal<Var> var;

    protected App() {
    }

    public static IRequest getRequest() {
        return (IRequest)App.get("NLF_REQUEST");
    }

    public static IResponse getResponse() {
        return (IResponse)App.get("NLF_RESPONSE");
    }

    public static void set(String key, Object value) {
        var.get().set(key, value);
    }

    public static <T> T get(String key) {
        return (T)var.get().get(key);
    }

    public static List<String> getImplements(String ... interfaceOrClassNames) {
        ArrayList<String> l = null;
        for (String name : interfaceOrClassNames) {
            ClassResource r = CLASS.get(name);
            if (null == r) {
                return new ArrayList<String>();
            }
            ArrayList<String> sub = new ArrayList<String>();
            if (r.isInterfaceClass()) {
                List<String> impls = INTERFACE_IMPLEMENTS.get(name);
                if (null != impls) {
                    sub.addAll(impls);
                }
            } else {
                sub.add(name);
            }
            if (null == l) {
                l = sub;
                continue;
            }
            l.retainAll(sub);
        }
        return l;
    }

    public static List<String> getImplements(Class<?> ... interfaceOrClasses) {
        ArrayList<String> l = null;
        for (Class<?> klass : interfaceOrClasses) {
            String name = klass.getName();
            ClassResource r = CLASS.get(name);
            if (null == r) {
                return new ArrayList<String>();
            }
            ArrayList<String> sub = new ArrayList<String>();
            if (r.isInterfaceClass()) {
                List<String> impls = INTERFACE_IMPLEMENTS.get(name);
                if (null != impls) {
                    sub.addAll(impls);
                }
            } else {
                sub.add(name);
            }
            if (null == l) {
                l = sub;
                continue;
            }
            l.retainAll(sub);
        }
        return l;
    }

    public static String getImplement(String ... interfaceOrClassNames) {
        List<String> impls = App.getImplements(interfaceOrClassNames);
        return impls.size() < 1 ? null : impls.get(0);
    }

    public static String getImplement(Class<?> ... interfaceOrClasses) {
        List<String> impls = App.getImplements(interfaceOrClasses);
        return impls.size() < 1 ? null : impls.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IProxy getProxy() {
        if (null != proxy) return proxy;
        Class<DefaultProxy> clazz = DefaultProxy.class;
        synchronized (DefaultProxy.class) {
            if (null != proxy) return proxy;
            proxy = (IProxy)new DefaultProxy().newInstance(IProxy.class.getName());
            // ** MonitorExit[var0] (shouldn't be in output)
            return proxy;
        }
    }

    public static String getProperty(String key, Object ... params) {
        IRequest r = App.getRequest();
        Locale locale = null == r ? Locale.getDefault() : r.getClient().getLocale();
        return App.getProperty(locale, key, params);
    }

    public static String getProperty(Locale locale, String key, Object ... params) {
        String value = null;
        Map<Locale, String> values = I18N_CACHE.get(key);
        if (null == values) {
            values = new HashMap<Locale, String>();
            I18N_CACHE.put(key, values);
        }
        if (!values.containsKey(locale)) {
            for (String i18n : I18N) {
                try {
                    ResourceBundle rb = ResourceBundle.getBundle(i18n, locale);
                    value = rb.getString(key);
                    break;
                }
                catch (Exception exception) {
                }
            }
            values.put(locale, value);
        } else {
            value = values.get(locale);
        }
        return null == value ? null : (params.length > 0 ? MessageFormat.format(value, params) : value);
    }

    static {
        DIRECTORIES = new LinkedHashSet<String>();
        I18N = new LinkedHashSet<String>();
        PACKAGE = App.class.getPackage().getName();
        I18N_RESOURCE = new ArrayList<I18nResource>();
        CLASS = new HashMap<String, ClassResource>();
        INTERFACE_IMPLEMENTS = new HashMap<String, List<String>>();
        I18N_CACHE = new HashMap<String, Map<Locale, String>>();
        var = new ThreadLocal<Var>(){

            @Override
            public Var initialValue() {
                return new Var();
            }
        };
        ScannerFactory.startScan();
    }
}

