/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.bytecode;

import com.nlf.bytecode.Klass;
import com.nlf.util.StringUtil;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Method {
    public static final String VOID = "V";
    private int access;
    private Klass klass;
    private int nameIndex;
    private int descriptorIndex;
    private String name;
    private String descriptor;
    private List<String> args = new ArrayList<String>();
    private String ret;
    private String retMaybe;

    public Method(Klass klass) {
        this.klass = klass;
    }

    public boolean isInit() {
        return "<init>".equals(this.getName());
    }

    public boolean isClInit() {
        return "<clinit>".equals(this.getName());
    }

    public String getName() {
        if (null == this.name) {
            this.name = this.klass.getConstant(this.nameIndex).toUTFConstant().getContent();
        }
        return this.name;
    }

    public String getDescripter() {
        if (null == this.descriptor) {
            String[] arrArg;
            this.descriptor = this.klass.getConstant(this.descriptorIndex).toUTFConstant().getContent();
            String[] arrDesc = this.descriptor.split("\\)", -1);
            for (String arg : arrArg = arrDesc[0].substring(1).split(";", -1)) {
                if (arg.length() <= 0) continue;
                this.args.add(arg);
            }
            this.ret = arrDesc[1].replace(";", "");
        }
        return this.descriptor;
    }

    public List<String> getArgs() {
        this.getDescripter();
        return this.args;
    }

    public String getRet() {
        this.getDescripter();
        return this.ret;
    }

    public String getRetMaybe() {
        return this.retMaybe;
    }

    public void setRetMaybe(String retMaybe) {
        this.retMaybe = retMaybe;
    }

    public int getAccess() {
        return this.access;
    }

    public void setAccess(int access) {
        this.access = access;
    }

    public Klass getKlass() {
        return this.klass;
    }

    public void setNameIndex(int nameIndex) {
        this.nameIndex = nameIndex;
    }

    public void setDescriptorIndex(int descriptorIndex) {
        this.descriptorIndex = descriptorIndex;
    }

    public String toString() {
        ArrayList<String> l = new ArrayList<String>();
        l.add(this.access + "");
        l.add(this.getRet());
        l.add(this.getName());
        l.add("(");
        l.add(StringUtil.join(this.getArgs(), ","));
        l.add(")");
        return StringUtil.join(l, " ");
    }
}

