/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.dao;

import com.nlf.App;
import com.nlf.dao.IDao;
import com.nlf.dao.connection.ConnectionFactory;
import com.nlf.dao.connection.IConnection;
import com.nlf.dao.exception.DaoException;
import com.nlf.dao.executer.AbstractDaoExecuter;
import com.nlf.dao.executer.IDaoExecuter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractDao
implements IDao {
    protected static final Map<String, Map<String, String>> executers = new HashMap<String, Map<String, String>>();
    protected String alias;

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    protected IConnection getConnection() {
        return ConnectionFactory.getConnection(this.alias);
    }

    protected IDaoExecuter getImpl(String dbType, String executerInterface) {
        String key;
        Map<String, String> impls = executers.get(dbType);
        if (null == impls) {
            impls = new HashMap<String, String>();
            executers.put(dbType, impls);
        }
        if (!impls.containsKey(key = executerInterface)) {
            List<String> l = App.getImplements(executerInterface);
            for (String klass : l) {
                IDaoExecuter executer = (IDaoExecuter)App.getProxy().newInstance(klass);
                if (!executer.support(dbType)) continue;
                impls.put(key, klass);
                return executer;
            }
            impls.put(key, null);
        } else {
            String impl = impls.get(key);
            if (null != impl) {
                return (IDaoExecuter)App.getProxy().newInstance(impl);
            }
        }
        throw new DaoException(App.getProperty("nlf.exception.dao.executer.not_found", dbType, executerInterface));
    }

    protected IDaoExecuter getExecuter(String executerInterface) {
        IConnection connection = this.getConnection();
        String dbType = connection.getDbSetting().getDbType();
        AbstractDaoExecuter executer = (AbstractDaoExecuter)this.getImpl(dbType, executerInterface);
        executer.setConnection(connection);
        return executer;
    }
}

