/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.dao.connection;

import com.nlf.App;
import com.nlf.dao.connection.IConnectionProvider;
import com.nlf.dao.exception.DaoException;
import com.nlf.dao.setting.IDbSetting;
import com.nlf.log.Logger;
import java.util.HashSet;
import java.util.Set;

public abstract class AbstractConnectionProvider
implements IConnectionProvider {
    protected static final Set<String> REGISTED_DRIVERS = new HashSet<String>();
    protected IDbSetting setting;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDbSetting(IDbSetting setting) {
        this.setting = setting;
        String driver = setting.getDriver();
        if (null == driver) {
            return;
        }
        AbstractConnectionProvider abstractConnectionProvider = this;
        synchronized (abstractConnectionProvider) {
            if (REGISTED_DRIVERS.contains(driver)) {
                return;
            }
            try {
                Class.forName(driver);
                REGISTED_DRIVERS.add(driver);
            }
            catch (ClassNotFoundException e) {
                throw new DaoException(App.getProperty("nlf.exception.dao.driver.not_found", driver), e);
            }
            Logger.getLog().debug(App.getProperty("nlf.dao.driver.registed", driver));
        }
    }
}

