/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.dao.setting;

import com.nlf.App;
import com.nlf.dao.exception.DaoException;
import com.nlf.dao.setting.IDbSetting;
import com.nlf.dao.setting.IDbSettingManager;
import com.nlf.dao.setting.impl.DefaultDbSettingComparator;
import com.nlf.log.Logger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbSettingFactory {
    public static final Comparator<IDbSetting> DEFAULT_COMPARATOR = new DefaultDbSettingComparator();
    protected static final Map<String, IDbSetting> SETTING_POOL = new HashMap<String, IDbSetting>();
    protected static final List<IDbSetting> SETTING_LIST = new ArrayList<IDbSetting>();
    protected static Comparator<IDbSetting> comparator = DEFAULT_COMPARATOR;

    protected DbSettingFactory() {
    }

    private static synchronized void init() {
        IDbSettingManager dsm = (IDbSettingManager)App.getProxy().newInstance(IDbSettingManager.class.getName());
        List<IDbSetting> l = dsm.listDbSettings();
        for (IDbSetting o : l) {
            SETTING_POOL.put(o.getAlias(), o);
            SETTING_LIST.add(o);
        }
        if (l.size() > 0) {
            Logger.getLog().debug(App.getProperty("nlf.dao.setting.found", l.size(), l));
            DbSettingFactory.sort();
        }
    }

    protected static synchronized void sort() {
        Collections.sort(SETTING_LIST, comparator);
    }

    public static synchronized void setComparator(Comparator<IDbSetting> c) {
        comparator = c;
    }

    public static List<String> getSettingAliasList() {
        ArrayList<String> l = new ArrayList<String>();
        for (IDbSetting setting : SETTING_LIST) {
            l.add(setting.getAlias());
        }
        return l;
    }

    public static synchronized void addSetting(IDbSetting setting) {
        String alias = setting.getAlias();
        DbSettingFactory.removeSetting(alias);
        SETTING_LIST.add(setting);
        SETTING_POOL.put(alias, setting);
        DbSettingFactory.sort();
    }

    public static synchronized void removeSetting(String alias) {
        if (!SETTING_POOL.containsKey(alias)) {
            return;
        }
        int index = -1;
        int j = SETTING_LIST.size();
        for (int i = 0; i < j; ++i) {
            if (!SETTING_LIST.get(i).getAlias().equals(alias)) continue;
            index = i;
            break;
        }
        if (index > -1) {
            SETTING_LIST.remove(index);
        }
        SETTING_POOL.remove(alias);
    }

    public static IDbSetting getSetting(String alias) {
        if (SETTING_POOL.containsKey(alias)) {
            return SETTING_POOL.get(alias);
        }
        throw new DaoException(App.getProperty("nlf.exception.dao.setting.not_found", alias));
    }

    public static int size() {
        return SETTING_POOL.size();
    }

    public static IDbSetting getDefaultSetting() {
        if (SETTING_LIST.size() < 1) {
            throw new DaoException(App.getProperty("nlf.exception.dao.setting.default_not_found", new Object[0]));
        }
        return SETTING_LIST.get(0);
    }

    static {
        DbSettingFactory.init();
    }
}

