/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.dao.setting.impl;

import com.nlf.App;
import com.nlf.Bean;
import com.nlf.dao.exception.DaoException;
import com.nlf.dao.setting.IDbSetting;
import com.nlf.dao.setting.IDbSettingFileFilter;
import com.nlf.dao.setting.IDbSettingManager;
import com.nlf.dao.setting.IDbSettingProvider;
import com.nlf.serialize.json.JSON;
import com.nlf.util.FileUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDbSettingManager
implements IDbSettingManager {
    protected static IDbSettingFileFilter filter;
    protected static List<IDbSettingProvider> dbSettingProviders;

    protected static void init() {
        filter = (IDbSettingFileFilter)App.getProxy().newInstance(IDbSettingFileFilter.class.getName());
        List<String> impls = App.getImplements(IDbSettingProvider.class);
        for (String klass : impls) {
            IDbSettingProvider dsp = (IDbSettingProvider)App.getProxy().newInstance(klass);
            dbSettingProviders.add(dsp);
        }
    }

    protected List<IDbSetting> listDbSettings(String directory) {
        ArrayList<IDbSetting> l = new ArrayList<IDbSetting>();
        File dir = new File(directory, App.getProperty("nlf.dao.setting.dir", new Object[0]));
        if (dir.exists()) {
            File[] fs;
            block2: for (File f : fs = dir.listFiles(filter)) {
                try {
                    Bean o = (Bean)JSON.toBean(FileUtil.readAsText(f));
                    String type = o.getString("type", "").toUpperCase();
                    for (IDbSettingProvider dsp : dbSettingProviders) {
                        if (!dsp.support(type)) continue;
                        l.add(dsp.buildDbSetting(o));
                        continue block2;
                    }
                }
                catch (Exception e) {
                    throw new DaoException(App.getProperty("nlf.exception.dao.setting.format", f.getName()), e);
                }
            }
        }
        return l;
    }

    @Override
    public List<IDbSetting> listDbSettings() {
        ArrayList<IDbSetting> l = new ArrayList<IDbSetting>();
        for (String directory : App.DIRECTORIES) {
            l.addAll(this.listDbSettings(directory));
        }
        return l;
    }

    static {
        dbSettingProviders = new ArrayList<IDbSettingProvider>();
        DefaultDbSettingManager.init();
    }
}

