/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.extend.dao.sql;

import com.nlf.App;
import com.nlf.Bean;
import com.nlf.dao.executer.AbstractDaoExecuter;
import com.nlf.extend.dao.sql.Condition;
import com.nlf.extend.dao.sql.ConditionType;
import com.nlf.extend.dao.sql.ISqlExecuter;
import com.nlf.util.IOUtil;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSqlExecuter
extends AbstractDaoExecuter
implements ISqlExecuter {
    protected String sql;
    protected List<Object> params = new ArrayList<Object>();
    protected List<String> tables = new ArrayList<String>();
    protected List<String> columns = new ArrayList<String>();
    protected List<String> groupBys = new ArrayList<String>();
    protected List<String> sorts = new ArrayList<String>();
    protected List<Condition> wheres = new ArrayList<Condition>();
    protected List<Condition> havings = new ArrayList<Condition>();

    @Override
    public boolean support(String dbType) {
        return true;
    }

    protected String buildLog() {
        StringBuilder s = new StringBuilder();
        s.append(App.getProperty("nlf.dao.executer.sql.statement", this.sql));
        int j = this.params.size();
        for (int i = 0; i < j; ++i) {
            s.append(App.getProperty("nlf.dao.executer.sql.parameter", i, this.params.get(i)));
        }
        return s.toString();
    }

    protected List<Bean> toBeans(ResultSet rs) throws SQLException {
        ArrayList<Bean> l = new ArrayList<Bean>();
        while (rs.next()) {
            ResultSetMetaData rsmd = rs.getMetaData();
            Bean o = new Bean();
            int j = rsmd.getColumnCount();
            for (int i = 1; i <= j; ++i) {
                o.set(rsmd.getColumnLabel(i), rs.getObject(i));
            }
            l.add(o);
        }
        return l;
    }

    protected void finalize(Statement stmt, ResultSet rs) {
        IOUtil.closeQuietly(rs);
        IOUtil.closeQuietly(stmt);
        rs = null;
        stmt = null;
    }

    protected void finalize(Statement stmt) {
        this.finalize(stmt, null);
    }

    protected void bindParams(PreparedStatement stmt) throws SQLException {
        int j = this.params.size();
        for (int i = 1; i <= j; ++i) {
            Object p = this.params.get(i - 1);
            if (p instanceof Timestamp) {
                stmt.setTimestamp(i, (Timestamp)p);
                continue;
            }
            if (p instanceof Date) {
                stmt.setDate(i, (Date)p);
                continue;
            }
            if (p instanceof java.util.Date) {
                java.util.Date dd = (java.util.Date)p;
                stmt.setDate(i, new Date(dd.getTime()));
                continue;
            }
            stmt.setObject(i, p);
        }
    }

    protected String buildParams(String sql, Bean o) {
        if (null == o) {
            return sql;
        }
        if (sql.length() < 1) {
            return sql;
        }
        if (!sql.contains(":")) {
            return sql;
        }
        ArrayList<String> keys = new ArrayList<String>();
        Matcher m = Pattern.compile(":{1}\\w+").matcher(sql);
        while (m.find()) {
            String key = m.group();
            if (!keys.contains(key)) {
                keys.add(key);
            }
            this.params.add(o.get(key.substring(1)));
        }
        Collections.sort(keys, new Comparator<String>(){

            @Override
            public int compare(String a, String b) {
                return b.length() - a.length();
            }
        });
        String newSql = sql;
        for (String key : keys) {
            newSql = newSql.replace(key, "?");
        }
        return newSql;
    }

    protected void buildParams(List<Condition> l) {
        for (Condition c : l) {
            switch (c.getType()) {
                case one_param: {
                    this.params.add(c.getValue());
                    break;
                }
                case pure_sql: {
                    break;
                }
                case multi_params: {
                    Bean o = (Bean)c.getValue();
                    this.buildParams(c.getColumn(), o);
                    this.buildParams(c.getStart(), o);
                    this.buildParams(c.getPlaceholder(), o);
                    this.buildParams(c.getEnd(), o);
                }
            }
        }
    }

    @Override
    public String getSql() {
        return this.sql;
    }

    @Override
    public List<Object> getParams() {
        return this.params;
    }

    protected ISqlExecuter where(String sql) {
        Condition cond = new Condition();
        cond.setColumn(sql);
        cond.setStart("");
        cond.setPlaceholder("");
        cond.setEnd("");
        cond.setType(ConditionType.pure_sql);
        this.wheres.add(cond);
        return this;
    }

    protected ISqlExecuter where(String column, Object value) {
        Condition cond = new Condition();
        cond.setColumn(column);
        if (null == value) {
            cond.setStart(" IS");
            cond.setPlaceholder(" NULL");
            cond.setType(ConditionType.pure_sql);
        } else {
            cond.setValue(value);
        }
        this.wheres.add(cond);
        return this;
    }

    protected ISqlExecuter whereNotEqual(String column, Object value) {
        Condition cond = new Condition();
        cond.setColumn(column);
        if (null == value) {
            cond.setStart(" IS NOT");
            cond.setPlaceholder(" NULL");
            cond.setType(ConditionType.pure_sql);
        } else {
            cond.setStart("!=");
            cond.setValue(value);
        }
        this.wheres.add(cond);
        return this;
    }

    protected ISqlExecuter where(String sql, Bean param) {
        Condition cond = new Condition();
        cond.setColumn(sql);
        cond.setStart("");
        cond.setPlaceholder("");
        cond.setEnd("");
        cond.setValue(param);
        cond.setType(ConditionType.multi_params);
        this.wheres.add(cond);
        return this;
    }

    protected ISqlExecuter whereIf(String sql, boolean condition) {
        if (condition) {
            this.where(sql);
        }
        return this;
    }

    protected ISqlExecuter whereIf(String column, Object value, boolean condition) {
        if (condition) {
            this.where(column, value);
        }
        return this;
    }

    protected ISqlExecuter whereIf(String sql, Bean values, boolean condition) {
        if (condition) {
            this.where(sql, values);
        }
        return this;
    }

    protected ISqlExecuter whereIn(String column, Object ... values) {
        if (1 == values.length) {
            return this.where(column, values[0]);
        }
        Condition cond = new Condition();
        cond.setColumn(column);
        cond.setStart(" IN(");
        Bean param = new Bean();
        StringBuilder placeholder = new StringBuilder();
        int i = 0;
        for (Object v : values) {
            if (i > 0) {
                placeholder.append(",");
            }
            String key = column.replaceAll("\\W", "") + "_" + i;
            placeholder.append(":" + key);
            param.set(key, v);
            ++i;
        }
        cond.setPlaceholder(placeholder.toString());
        cond.setEnd(")");
        cond.setValue(param);
        cond.setType(ConditionType.multi_params);
        this.wheres.add(cond);
        return this;
    }

    protected ISqlExecuter whereNotIn(String column, Object ... values) {
        if (1 == values.length) {
            Object v = values[0];
            if (null == v) {
                return this.where(column + " IS NOT NULL");
            }
            return this.where(column + " != :" + column, new Bean(column, v));
        }
        Condition cond = new Condition();
        cond.setColumn(column);
        cond.setStart(" NOT IN(");
        Bean param = new Bean();
        StringBuilder placeholder = new StringBuilder();
        int i = 0;
        for (Object v : values) {
            if (i > 0) {
                placeholder.append(",");
            }
            String key = column.replaceAll("\\W", "") + "_" + i;
            placeholder.append(":" + key);
            param.set(key, v);
            ++i;
        }
        cond.setPlaceholder(placeholder.toString());
        cond.setEnd(")");
        cond.setValue(param);
        cond.setType(ConditionType.multi_params);
        this.wheres.add(cond);
        return this;
    }
}

