/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.extend.dao.sql.dbType.common;

import com.nlf.Bean;
import com.nlf.dao.exception.DaoException;
import com.nlf.extend.dao.sql.AbstractSqlExecuter;
import com.nlf.extend.dao.sql.Condition;
import com.nlf.extend.dao.sql.ConditionType;
import com.nlf.extend.dao.sql.ISqlInserter;
import com.nlf.extend.dao.sql.SqlConnection;
import com.nlf.log.Logger;
import com.nlf.util.StringUtil;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class ASqlInserter
extends AbstractSqlExecuter
implements ISqlInserter {
    protected List<Condition> columns = new ArrayList<Condition>();

    public ISqlInserter table(String tables) {
        this.tables.add(tables);
        return this;
    }

    public ISqlInserter tableIf(String tables, boolean condition) {
        if (condition) {
            this.table(tables);
        }
        return this;
    }

    public String buildSql() {
        Condition r;
        int i;
        StringBuffer s = new StringBuffer();
        s.append("INSERT INTO ");
        s.append(StringUtil.join(this.tables, ","));
        s.append("(");
        int l = this.columns.size();
        for (i = 0; i < l; ++i) {
            s.append(i < 1 ? "" : ",");
            r = this.columns.get(i);
            s.append(r.getColumn());
        }
        s.append(") VALUES(");
        int j = this.columns.size();
        block6: for (i = 0; i < j; ++i) {
            s.append(i < 1 ? "" : ",");
            r = this.columns.get(i);
            switch (r.getType()) {
                case one_param: {
                    this.params.add(r.getValue());
                }
                case pure_sql: {
                    s.append(r.getStart());
                    s.append(r.getPlaceholder());
                    s.append(r.getEnd());
                    continue block6;
                }
                case multi_params: {
                    Bean o = (Bean)r.getValue();
                    s.append(this.buildParams(r.getStart(), o));
                    s.append(this.buildParams(r.getPlaceholder(), o));
                    s.append(this.buildParams(r.getEnd(), o));
                }
            }
        }
        s.append(")");
        return s.toString();
    }

    public int insert() {
        int n;
        block11: {
            SqlConnection conn;
            PreparedStatement stmt;
            block9: {
                int n2;
                block10: {
                    this.params.clear();
                    this.sql = this.buildSql();
                    Logger.getLog().debug(this.buildLog());
                    stmt = null;
                    conn = null;
                    conn = (SqlConnection)this.connection;
                    if (conn.isInBatch()) {
                        stmt = conn.getStatement();
                        if (null == stmt) {
                            stmt = conn.getConnection().prepareStatement(this.sql);
                            conn.setStatement(stmt);
                        }
                    } else {
                        stmt = conn.getConnection().prepareStatement(this.sql);
                    }
                    this.bindParams(stmt);
                    if (!conn.isInBatch()) break block9;
                    stmt.addBatch();
                    n2 = -1;
                    if (conn.isInBatch()) break block10;
                    this.finalize(stmt);
                }
                return n2;
            }
            try {
                n = stmt.executeUpdate();
                if (conn.isInBatch()) break block11;
            }
            catch (SQLException e) {
                try {
                    throw new DaoException(e);
                }
                catch (Throwable throwable) {
                    if (!conn.isInBatch()) {
                        this.finalize(stmt);
                    }
                    throw throwable;
                }
            }
            this.finalize(stmt);
        }
        return n;
    }

    public ISqlInserter set(String sql) {
        Condition cond = new Condition();
        cond.setColumn(sql);
        cond.setStart("");
        cond.setPlaceholder("");
        cond.setType(ConditionType.pure_sql);
        this.columns.add(cond);
        return this;
    }

    public ISqlInserter set(String column, Object value) {
        Condition cond = new Condition();
        cond.setColumn(column);
        cond.setStart("");
        cond.setValue(value);
        this.columns.add(cond);
        return this;
    }

    public ISqlInserter set(String sql, Bean param) {
        Condition cond = new Condition();
        cond.setColumn(sql);
        cond.setStart("");
        cond.setValue(param);
        if (null != param) {
            cond.setType(ConditionType.multi_params);
            cond.setPlaceholder("");
        }
        this.columns.add(cond);
        return this;
    }

    public ISqlInserter set(Bean bean) {
        for (String key : bean.keySet()) {
            this.set(key, bean.get(key));
        }
        return this;
    }

    public ISqlInserter setIf(String sql, boolean condition) {
        if (condition) {
            this.set(sql);
        }
        return this;
    }

    public ISqlInserter setIf(String column, Object value, boolean condition) {
        if (condition) {
            this.set(column, value);
        }
        return this;
    }

    public ISqlInserter setIf(String sql, Bean param, boolean condition) {
        if (condition) {
            this.set(sql, param);
        }
        return this;
    }

    public ISqlInserter setIf(Bean bean, boolean condition) {
        if (condition) {
            this.set(bean);
        }
        return this;
    }
}

