/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.extend.dao.sql.dbType.common;

import com.nlf.App;
import com.nlf.Bean;
import com.nlf.core.IRequest;
import com.nlf.dao.exception.DaoException;
import com.nlf.dao.paging.PageData;
import com.nlf.extend.dao.sql.AbstractSqlExecuter;
import com.nlf.extend.dao.sql.Condition;
import com.nlf.extend.dao.sql.ConditionType;
import com.nlf.extend.dao.sql.ISqlSelecter;
import com.nlf.extend.dao.sql.ResultSetIterator;
import com.nlf.extend.dao.sql.SqlConnection;
import com.nlf.log.Logger;
import com.nlf.util.StringUtil;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ASqlSelecter
extends AbstractSqlExecuter
implements ISqlSelecter {
    @Override
    public ISqlSelecter table(String tables) {
        this.tables.add(tables);
        return this;
    }

    @Override
    public ISqlSelecter tableIf(String tables, boolean condition) {
        if (condition) {
            this.table(tables);
        }
        return this;
    }

    @Override
    public ISqlSelecter column(String columns) {
        this.columns.add(columns);
        return this;
    }

    @Override
    public ISqlSelecter columnIf(String columns, boolean condition) {
        if (condition) {
            this.column(columns);
        }
        return this;
    }

    @Override
    public ISqlSelecter where(String sql) {
        super.where(sql);
        return this;
    }

    @Override
    public ISqlSelecter where(String column, Object value) {
        super.where(column, value);
        return this;
    }

    @Override
    public ISqlSelecter where(String sql, Bean param) {
        super.where(sql, param);
        return this;
    }

    @Override
    public ISqlSelecter whereIf(String sql, boolean condition) {
        if (condition) {
            this.where(sql);
        }
        return this;
    }

    @Override
    public ISqlSelecter whereIf(String column, Object value, boolean condition) {
        if (condition) {
            this.where(column, value);
        }
        return this;
    }

    @Override
    public ISqlSelecter whereIf(String sql, Bean param, boolean condition) {
        if (condition) {
            this.where(sql, param);
        }
        return this;
    }

    @Override
    public ISqlSelecter whereIn(String column, Object ... values) {
        super.whereIn(column, values);
        return this;
    }

    @Override
    public ISqlSelecter whereNotIn(String column, Object ... values) {
        super.whereNotIn(column, values);
        return this;
    }

    @Override
    public ISqlSelecter whereNotEqual(String column, Object value) {
        super.whereNotEqual(column, value);
        return this;
    }

    @Override
    public ISqlSelecter having(String sql) {
        Condition cond = new Condition();
        cond.setColumn(sql);
        cond.setStart("");
        cond.setPlaceholder("");
        cond.setEnd("");
        cond.setType(ConditionType.pure_sql);
        this.havings.add(cond);
        return this;
    }

    @Override
    public ISqlSelecter having(String column, Object value) {
        Condition cond = new Condition();
        cond.setColumn(column);
        cond.setValue(value);
        this.havings.add(cond);
        return this;
    }

    @Override
    public ISqlSelecter having(String sql, Bean param) {
        Condition cond = new Condition();
        cond.setColumn(sql);
        cond.setStart("");
        cond.setPlaceholder("");
        cond.setEnd("");
        cond.setValue(param);
        cond.setType(ConditionType.multi_params);
        this.havings.add(cond);
        return this;
    }

    @Override
    public ISqlSelecter havingIf(String sql, boolean condition) {
        if (condition) {
            this.having(sql);
        }
        return this;
    }

    @Override
    public ISqlSelecter havingIf(String column, Object value, boolean condition) {
        if (condition) {
            this.having(column, value);
        }
        return this;
    }

    @Override
    public ISqlSelecter havingIf(String sql, Bean param, boolean condition) {
        if (condition) {
            this.having(sql, param);
        }
        return this;
    }

    @Override
    public ISqlSelecter groupBy(String columns) {
        this.groupBys.add(columns);
        return this;
    }

    @Override
    public ISqlSelecter groupByIf(String columns, boolean condition) {
        if (condition) {
            this.groupBy(columns);
        }
        return this;
    }

    @Override
    public ISqlSelecter asc(String columns) {
        String[] cols;
        for (String col : cols = columns.split(",", -1)) {
            if (col.length() <= 0) continue;
            this.sorts.add(col + " ASC");
        }
        return this;
    }

    @Override
    public ISqlSelecter ascIf(String columns, boolean condition) {
        if (condition) {
            this.asc(columns);
        }
        return this;
    }

    @Override
    public ISqlSelecter desc(String columns) {
        String[] cols;
        for (String col : cols = columns.split(",", -1)) {
            if (col.length() <= 0) continue;
            this.sorts.add(col + " DESC");
        }
        return this;
    }

    @Override
    public ISqlSelecter descIf(String columns, boolean condition) {
        if (condition) {
            this.desc(columns);
        }
        return this;
    }

    public String buildSql() {
        Bean o;
        Condition r;
        int i;
        StringBuffer s = new StringBuffer();
        s.append("SELECT ");
        s.append(this.columns.size() < 1 ? "*" : StringUtil.join(this.columns, ","));
        s.append(" FROM ");
        s.append(StringUtil.join(this.tables, ","));
        int l = this.wheres.size();
        block10: for (i = 0; i < l; ++i) {
            s.append(" ");
            s.append(i < 1 ? "WHERE" : "AND");
            s.append(" ");
            r = (Condition)this.wheres.get(i);
            switch (r.getType()) {
                case one_param: {
                    this.params.add(r.getValue());
                }
                case pure_sql: {
                    s.append(r.getColumn());
                    s.append(r.getStart());
                    s.append(r.getPlaceholder());
                    s.append(r.getEnd());
                    continue block10;
                }
                case multi_params: {
                    o = (Bean)r.getValue();
                    s.append(this.buildParams(r.getColumn(), o));
                    s.append(this.buildParams(r.getStart(), o));
                    s.append(this.buildParams(r.getPlaceholder(), o));
                    s.append(this.buildParams(r.getEnd(), o));
                }
            }
        }
        int j = this.groupBys.size();
        for (i = 0; i < j; ++i) {
            s.append(" ");
            s.append(i < 1 ? "GROUP BY " : ",");
            s.append((String)this.groupBys.get(i));
        }
        l = this.havings.size();
        block12: for (i = 0; i < l; ++i) {
            s.append(" ");
            s.append(i < 1 ? "HAVING" : "AND");
            s.append(" ");
            r = (Condition)this.havings.get(i);
            switch (r.getType()) {
                case one_param: {
                    this.params.add(r.getValue());
                }
                case pure_sql: {
                    s.append(r.getColumn());
                    s.append(r.getStart());
                    s.append(r.getPlaceholder());
                    s.append(r.getEnd());
                    continue block12;
                }
                case multi_params: {
                    o = (Bean)r.getValue();
                    s.append(this.buildParams(r.getColumn(), o));
                    s.append(this.buildParams(r.getStart(), o));
                    s.append(this.buildParams(r.getPlaceholder(), o));
                    s.append(this.buildParams(r.getEnd(), o));
                }
            }
        }
        j = this.sorts.size();
        for (i = 0; i < j; ++i) {
            s.append(" ");
            s.append(i < 1 ? "ORDER BY " : ",");
            s.append((String)this.sorts.get(i));
        }
        return s.toString();
    }

    @Override
    public List<Bean> query() {
        List<Bean> list;
        this.params.clear();
        this.sql = this.buildSql();
        Logger.getLog().debug(this.buildLog());
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = ((SqlConnection)this.connection).getConnection().prepareStatement(this.sql);
            this.bindParams(stmt);
            rs = stmt.executeQuery();
            list = this.toBeans(rs);
        }
        catch (SQLException e) {
            try {
                throw new DaoException(e);
            }
            catch (Throwable throwable) {
                this.finalize(stmt, rs);
                throw throwable;
            }
        }
        this.finalize(stmt, rs);
        return list;
    }

    @Override
    public List<Bean> top(int count) {
        throw new DaoException(App.getProperty("nlf.exception.dao.operation_not_support", new Object[0]));
    }

    @Override
    public Bean topOne() {
        List<Bean> l = this.top(1);
        if (l.size() < 1) {
            throw new DaoException(App.getProperty("nlf.exception.dao.select.one.not_found", new Object[0]));
        }
        return l.get(0);
    }

    @Override
    public Bean one() {
        List<Bean> l = this.query();
        if (l.size() < 1) {
            throw new DaoException(App.getProperty("nlf.exception.dao.select.one.not_found", new Object[0]));
        }
        return l.get(0);
    }

    @Override
    public int count() {
        this.params.clear();
        this.sql = this.buildSql();
        this.sql = "SELECT COUNT(*) NLFCOUNT_ FROM (" + this.sql + ") NLFTABLE_";
        Logger.getLog().debug(this.buildLog());
        PreparedStatement stmt = null;
        ResultSet rs = null;
        List<Bean> l = null;
        try {
            stmt = ((SqlConnection)this.connection).getConnection().prepareStatement(this.sql);
            this.bindParams(stmt);
            rs = stmt.executeQuery();
            l = this.toBeans(rs);
        }
        catch (SQLException e) {
            try {
                throw new DaoException(e);
            }
            catch (Throwable throwable) {
                this.finalize(stmt, rs);
                throw throwable;
            }
        }
        this.finalize(stmt, rs);
        if (l.size() < 1) {
            throw new DaoException(App.getProperty("nlf.exception.dao.select.one.not_found", new Object[0]));
        }
        Bean o = l.get(0);
        return o.getInt("NLFCOUNT_", 0);
    }

    @Override
    public PageData page(int pageNumber, int pageSize) {
        throw new DaoException(App.getProperty("nlf.exception.dao.operation_not_support", new Object[0]));
    }

    @Override
    public PageData paging() {
        IRequest r = App.getRequest();
        return this.page(r.getPageNumber(), r.getPageSize());
    }

    @Override
    public Iterator<Bean> iterator() {
        this.params.clear();
        this.sql = this.buildSql();
        Logger.getLog().debug(this.buildLog());
        ResultSetIterator iterator = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = ((SqlConnection)this.connection).getConnection().prepareStatement(this.sql);
            this.bindParams(stmt);
            rs = stmt.executeQuery();
            iterator = new ResultSetIterator(rs);
        }
        catch (SQLException e) {
            this.finalize(stmt, rs);
            throw new DaoException(e);
        }
        return iterator;
    }
}

