/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.extend.serialize.obj.impl;

import com.nlf.serialize.IParser;
import com.nlf.serialize.json.JSON;
import com.nlf.util.Base64Util;
import com.nlf.util.IOUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.zip.ZipInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultObjParser
implements IParser {
    public static int BUFFER_SIZE = 4096;

    @Override
    public boolean support(String format) {
        return "obj".equalsIgnoreCase(format);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T parse(String s) {
        Object obj = null;
        ByteArrayOutputStream bObj = null;
        ByteArrayInputStream bZip = null;
        ObjectInputStream iObj = null;
        ZipInputStream iZip = null;
        try {
            bObj = new ByteArrayOutputStream();
            bZip = new ByteArrayInputStream(Base64Util.decode(s));
            iZip = new ZipInputStream(bZip);
            iZip.getNextEntry();
            byte[] buffer = new byte[BUFFER_SIZE];
            int offset = -1;
            while ((offset = iZip.read(buffer)) != -1) {
                bObj.write(buffer, 0, offset);
            }
            iObj = new ObjectInputStream(new ByteArrayInputStream(bObj.toByteArray()));
            obj = iObj.readObject();
        }
        catch (ClassNotFoundException e) {
            try {
                throw new RuntimeException(e);
                catch (IOException e2) {
                    throw new RuntimeException(e2);
                }
            }
            catch (Throwable throwable) {
                IOUtil.closeQuietly(iZip);
                IOUtil.closeQuietly(bZip);
                IOUtil.closeQuietly(iObj);
                IOUtil.closeQuietly(bObj);
                throw throwable;
            }
        }
        IOUtil.closeQuietly(iZip);
        IOUtil.closeQuietly(bZip);
        IOUtil.closeQuietly(iObj);
        IOUtil.closeQuietly(bObj);
        return JSON.toBean(JSON.fromObject(obj));
    }
}

