/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.resource;

import com.nlf.resource.ResourceType;
import com.nlf.resource.klass.ClassResource;
import java.io.File;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class Resource {
    protected boolean inJar;
    protected String root;
    protected String fileName;
    protected ResourceType type;

    public boolean isInJar() {
        return this.inJar;
    }

    public void setInJar(boolean inJar) {
        this.inJar = inJar;
    }

    public String getRoot() {
        return this.root;
    }

    public void setRoot(String root) {
        this.root = root;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public ResourceType getType() {
        return this.type;
    }

    public void setType(ResourceType type) {
        this.type = type;
    }

    public long lastModified() throws IOException {
        if (this.inJar) {
            ZipFile zip = new ZipFile(this.root);
            ZipEntry en = zip.getEntry(this.fileName);
            return en.getTime();
        }
        switch (this.type) {
            case klass: {
                ClassResource res = (ClassResource)this;
                String pkg = res.getClassName();
                if (pkg.contains(".")) {
                    pkg = pkg.substring(0, pkg.lastIndexOf("."));
                }
                return new File(res.getRoot() + File.separator + pkg.replace(".", File.separator) + File.separator + res.getFileName()).lastModified();
            }
        }
        return new File(this.root + File.separator + this.fileName).lastModified();
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("type=");
        s.append((Object)this.type);
        s.append(" inJar=");
        s.append(this.inJar);
        s.append(" root=");
        s.append(this.root);
        s.append(" fileName=");
        s.append(this.fileName);
        return s.toString();
    }
}

