/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.serialize;

import com.nlf.App;
import com.nlf.exception.NlfException;
import com.nlf.serialize.IParser;
import com.nlf.serialize.IWrapper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ConvertFactory {
    public static final Map<String, String> parsers = new HashMap<String, String>();
    public static final Map<String, String> wrappers = new HashMap<String, String>();

    protected ConvertFactory() {
    }

    public static IParser getParser(String format) {
        if (!parsers.containsKey(format)) {
            List<String> impls = App.getImplements(IParser.class);
            for (String klass : impls) {
                IParser parser = (IParser)App.getProxy().newInstance(klass);
                if (!parser.support(format)) continue;
                parsers.put(format, klass);
                return parser;
            }
            parsers.put(format, null);
        } else {
            String impl = parsers.get(format);
            if (null != impl) {
                return (IParser)App.getProxy().newInstance(impl);
            }
        }
        throw new NlfException(App.getProperty("nlf.serialize.parser.not_found", format));
    }

    public static IWrapper getWrapper(String format) {
        if (!wrappers.containsKey(format)) {
            List<String> impls = App.getImplements(IWrapper.class);
            for (String klass : impls) {
                IWrapper wrapper = (IWrapper)App.getProxy().newInstance(klass);
                if (!wrapper.support(format)) continue;
                wrappers.put(format, klass);
                return wrapper;
            }
            wrappers.put(format, null);
        } else {
            String impl = wrappers.get(format);
            if (null != impl) {
                return (IWrapper)App.getProxy().newInstance(impl);
            }
        }
        throw new NlfException(App.getProperty("nlf.serialize.wrapper.not_found", format));
    }
}

